/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import oracle.jrockit.management.server.AgentError;
import oracle.jrockit.management.server.Connector;
import oracle.jrockit.management.server.Messages;
import oracle.jrockit.management.server.Option;
import oracle.jrockit.management.server.jdp.JDPConnector;
import oracle.jrockit.management.server.sun.LocalJMXConnectorImpl;
import oracle.jrockit.management.server.sun.RemoteJMXConnectorImpl;
import oracle.jrockit.management.server.sun.SunSNMPConnectorImpl;

public class Agent {
    private static boolean started;
    private static Connector localJMXConnector;
    private static Connector remoteJMXConnector;
    private static Connector snmpConnector;
    private static Connector jdpConnector;

    private static void start(Properties p) {
        String snmpPort;
        if (Option.ENABLE_THREAD_CONTENTION_MONITORING.isSet(p) && !Option.ENABLE_THREAD_CONTENTION_MONITORING.isFalse(p)) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        if ("-1".equals(snmpPort = Option.SNMP_PORT.valueOf(p))) {
            snmpPort = null;
        }
        if (snmpPort != null) {
            snmpConnector.start(p);
            Messages.info("agent.info.snmp.started", new Object[0]);
        }
        boolean remote = Option.JMXREMOTE.isTrueOrEmpty(p);
        String port = Option.JMXREMOTE_PORT.valueOf(p, null);
        if (port != null) {
            remoteJMXConnector.start(p);
        }
        if (remote || port != null && !Option.JMXREMOTE.isFalse(p)) {
            localJMXConnector.start(p);
        }
        if (Option.AUTODISCOVERY.isTrueOrEmpty(p)) {
            jdpConnector.start(p);
        }
        started = true;
    }

    private static void stop() {
        snmpConnector.stop();
        remoteJMXConnector.stop();
        jdpConnector.stop();
        localJMXConnector.stop();
        started = false;
    }

    public static void agentmain(String args) throws Exception {
        if (args == null || args.length() == 0) {
            args = Option.JMXREMOTE.qualifiedName();
        }
        Agent.main(args.split(","));
    }

    public static synchronized void main(String[] args) throws Exception {
        try {
            Properties p = new Properties();
            int count = 0;
            String[] arr$ = args;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String key;
                String arg;
                String s = arg = arr$[i$];
                String v = "";
                ++count;
                if (arg.equals("start")) {
                    if (count <= 1) continue;
                    throw new AgentError("agent.err.argmustbefirst", "start");
                }
                if (arg.equals("stop")) {
                    if (count > 1) {
                        throw new AgentError("agent.err.argmustbefirst", "stop");
                    }
                    if (args.length > 1) {
                        throw new AgentError("agent.err.toomanyargs");
                    }
                    if (started) {
                        Agent.stop();
                    }
                    return;
                }
                int n = s.indexOf(61);
                if (n != -1) {
                    v = s.substring(n + 1);
                    s = s.substring(0, n);
                }
                if ((key = Option.replaceArg(s = s.trim())) != null) {
                    p.put(key, v);
                    continue;
                }
                Messages.error("agent.err.invalid.option", arg);
            }
            if (started) {
                Messages.info("agent.info.alreadyrunning", new Object[0]);
                return;
            }
            p = Agent.readConfiguration(p);
            Agent.start(p);
        }
        catch (AgentError e) {
            Messages.error(e);
        }
        catch (Throwable e2) {
            Messages.error(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readConfiguration(Properties p) {
        block10: {
            Properties properties;
            File f;
            Properties sprops = System.getProperties();
            String name = Option.CONFIG_FILE.valueOf(p, null);
            if (name == null && p != sprops) {
                name = Option.CONFIG_FILE.valueOf(sprops);
            }
            if (name == null && p == sprops) {
                name = Option.CONFIG_FILE.defaultValue();
            }
            if (!(f = new File(name)).exists()) {
                Messages.error("agent.err.configfile.notfound", f.toString());
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                Properties pp = new Properties();
                pp.load(in);
                if (p != sprops) {
                    p.putAll(sprops);
                }
                pp.putAll(p);
                properties = pp;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                    throw throwable;
                }
                catch (IOException e) {
                    Messages.error("agent.err.configfile.failed", e.getMessage());
                    break block10;
                }
                catch (SecurityException e) {
                    Messages.error("agent.err.configfile.access.denied", name);
                }
            }
            ((InputStream)in).close();
            return properties;
        }
        return null;
    }

    private static void start(String args) throws Exception {
        Agent.agentmain("start," + args);
    }

    private static void stop(String args) throws Exception {
        Agent.agentmain("stop," + args);
    }

    static {
        localJMXConnector = new LocalJMXConnectorImpl();
        remoteJMXConnector = new RemoteJMXConnectorImpl();
        snmpConnector = new SunSNMPConnectorImpl();
        jdpConnector = new JDPConnector(remoteJMXConnector);
    }
}

