/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.oracle.jrockit.management.ThreadInfo;
import java.lang.management.ManagementFactory;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.ThreadingMBean;

class Threading
extends BeanBase
implements ThreadingMBean {
    private static final long[] EMPTY_ARRAY = new long[0];
    private final ThreadInfo threadInfo = new ThreadInfo();

    public Threading(JVMManagement mgmt) {
        super(mgmt);
    }

    public long[] getAllocatedBytes(long[] threadIDs) {
        Threading.checkMonitorAccess();
        return this.threadInfo.getAllocatedBytes(threadIDs);
    }

    public long getAllocatedBytes(long threadID) throws RuntimeException, IllegalArgumentException {
        Threading.checkMonitorAccess();
        if (threadID < 0L) {
            throw new IllegalArgumentException("Invalid thread ID parameter: " + threadID);
        }
        return this.threadInfo.getAllocatedBytes(threadID);
    }

    public long getCpuTime(long threadID) {
        Threading.checkMonitorAccess();
        return ManagementFactory.getThreadMXBean().getThreadCpuTime(threadID);
    }

    public long[] getCpuTime(long[] threadIDs) {
        if (threadIDs == null || threadIDs.length == 0) {
            return EMPTY_ARRAY;
        }
        long[] cpuTimes = new long[threadIDs.length];
        for (int i = 0; i < threadIDs.length; ++i) {
            cpuTimes[i] = this.getCpuTime(threadIDs[i]);
        }
        return cpuTimes;
    }
}

