/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.CPU;
import com.bea.jvm.Machine;
import com.bea.jvm.NotAvailableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.RuntimeMBean;

class Runtime
extends BeanBase
implements RuntimeMBean {
    private final Machine machine;

    public Runtime(JVMManagement mgmt) {
        super(mgmt);
        this.machine = this.jvm.getMachine();
    }

    public String[] getCPUDescriptions() {
        List<? extends CPU> cpus = this.machine.getCPUs();
        String[] descs = new String[cpus.size()];
        int n = 0;
        for (CPU cPU : cpus) {
            descs[n++] = cPU.getDescription();
        }
        return descs;
    }

    public double[] getCPULoads() {
        List<? extends CPU> cpus = this.machine.getCPUs();
        double[] res = new double[cpus.size()];
        int n = 0;
        for (CPU cPU : cpus) {
            res[n++] = cPU.getLoad();
        }
        return res;
    }

    public double getCPULoad() {
        return this.getSystemLoadAverage();
    }

    public double getVMGeneratedCPULoad() {
        return this.jvm.getJVMLoad();
    }

    public double getSystemLoadAverage() {
        return this.machine.getCPULoad();
    }

    public void setProcessAffinity(int[] bitmask) {
        Runtime.checkControlAccess();
        List<? extends CPU> cpus = this.machine.getCPUs();
        int noOfProcessors = cpus.size();
        if (bitmask.length * 32 < noOfProcessors) {
            throw new IllegalArgumentException("Minimum required array length: " + (noOfProcessors + 0));
        }
        ArrayList<CPU> cpusToUse = new ArrayList<CPU>(32 * bitmask.length + 16);
        for (int maskPos = 0; maskPos < bitmask.length; ++maskPos) {
            for (int i = 0; i < 32; ++i) {
                long currentBitValue = (long)Math.pow(2.0, i) & (long)bitmask[maskPos];
                if (currentBitValue <= 0L) continue;
                int cpuPos = 32 * maskPos + i;
                if (cpus.size() > cpuPos) {
                    cpusToUse.add(cpus.get(cpuPos));
                    continue;
                }
                throw new IllegalArgumentException("invalid cpu " + cpuPos);
            }
        }
        if (cpusToUse.size() > 0) {
            try {
                this.jvm.suggestProcessAffinity(cpusToUse);
            }
            catch (NotAvailableException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }

    public int[] getProcessAffinity() {
        List<? extends CPU> cpus = this.machine.getCPUs();
        int noOfProcessors = cpus.size();
        int[] bitMask = new int[(noOfProcessors + 31) / 32];
        try {
            Collection<CPU> activeCpus = this.jvm.getProcessAffinity();
            for (int i = 0; i < cpus.size(); ++i) {
                bitMask[i / 32] = bitMask[i / 32] | (activeCpus.contains(cpus.get(i)) ? (int)Math.pow(2.0, i % 32) : 0);
            }
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        return bitMask;
    }

    public int getProcessID() {
        return this.jvm.getOperatingSystem().getProcessID();
    }

    public String getPhysicalMachineID() {
        return this.jvm.getMachine().getPhysicalMachineID();
    }
}

