/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.ClassLibrary;
import com.bea.jvm.ExceptionProfileEntry;
import com.bea.jvm.MethodProfileEntry;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ProfilingSystem;
import com.bea.jvm.UnapplicableMethodException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.MethodID;
import oracle.jrockit.management.ProfilerMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Profiler
extends BeanBase
implements ProfilerMBean {
    private final HashMap<MethodID, MethodProfileEntry> methodEntries = new HashMap();
    private final HashMap<String, ExceptionProfileEntry> exceptionEntries = new HashMap();
    private final ProfilingSystem profilingSystem = this.jvm.getProfilingSystem();
    private final ClassLibrary classLibrary = this.jvm.getClassLibrary();

    public Profiler(JVMManagement mgmt) {
        super(mgmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodProfileEntry lookup(MethodID m) {
        HashMap<MethodID, MethodProfileEntry> hashMap = this.methodEntries;
        synchronized (hashMap) {
            return this.methodEntries.get(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionProfileEntry lookup(String s) {
        HashMap<String, ExceptionProfileEntry> hashMap = this.exceptionEntries;
        synchronized (hashMap) {
            return this.exceptionEntries.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodProfileEntry get(MethodID m) throws NoSuchMethodException, ClassNotFoundException {
        HashMap<MethodID, MethodProfileEntry> hashMap = this.methodEntries;
        synchronized (hashMap) {
            MethodProfileEntry e = this.lookup(m);
            if (e == null) {
                try {
                    e = (MethodProfileEntry)this.profilingSystem.newMethodProfileEntry(m.getMethod(this.getFirstClass(m.getClassName()))).getResetableInstance();
                }
                catch (UnapplicableMethodException t) {
                    throw new UnsupportedOperationException(t);
                }
                catch (NotAvailableException t2) {
                    throw new UnsupportedOperationException(t2);
                }
                this.methodEntries.put(m, e);
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionProfileEntry get(String s) throws ClassCastException, ClassNotFoundException {
        HashMap<String, ExceptionProfileEntry> hashMap = this.exceptionEntries;
        synchronized (hashMap) {
            ExceptionProfileEntry e = this.lookup(s);
            if (e == null) {
                Class<?> c = this.getFirstClass(s);
                e = this.profilingSystem.newExceptionProfileEntry(c.asSubclass(Throwable.class)).getResetableInstance();
                this.exceptionEntries.put(s, e);
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(MethodID m, MethodProfileEntry e) {
        HashMap<MethodID, MethodProfileEntry> hashMap = this.methodEntries;
        synchronized (hashMap) {
            if (!e.isInvocationCountEnabled() && !e.isTimingEnabled()) {
                this.methodEntries.remove(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String s, ExceptionProfileEntry e) {
        HashMap<String, ExceptionProfileEntry> hashMap = this.exceptionEntries;
        synchronized (hashMap) {
            if (!e.isSingleEnabled() && !e.isCompositeEnabled()) {
                this.exceptionEntries.remove(s);
            }
        }
    }

    private Class<?> getFirstClass(String name) throws ClassNotFoundException {
        return this.classLibrary.getAllClasses(name).iterator().next();
    }

    @Override
    public long getTiming(MethodID method) throws ClassNotFoundException, NoSuchMethodException {
        MethodProfileEntry e = this.lookup(method);
        return e != null ? e.getTiming() : 0L;
    }

    @Override
    public long getInvocationCount(MethodID method) throws ClassNotFoundException, NoSuchMethodException {
        MethodProfileEntry e = this.lookup(method);
        return e != null ? e.getInvocations() : 0L;
    }

    @Override
    public void setInvocationCountEnabled(MethodID method, boolean enable) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Profiler.checkControlAccess();
        MethodProfileEntry e = this.get(method);
        try {
            e.setInvocationCountEnabled(enable);
        }
        catch (NotAvailableException x) {
            throw new UnsupportedOperationException(x.getMessage());
        }
        this.check(method, e);
    }

    @Override
    public boolean isInvocationCountEnabled(MethodID method) throws ClassNotFoundException, NoSuchMethodException {
        MethodProfileEntry e = this.lookup(method);
        return e != null ? e.isInvocationCountEnabled() : false;
    }

    @Override
    public void setTimingEnabled(MethodID method, boolean enable) throws ClassNotFoundException, NoSuchMethodException {
        Profiler.checkControlAccess();
        MethodProfileEntry e = this.get(method);
        try {
            e.setTimingEnabled(enable);
        }
        catch (NotAvailableException x) {
            throw new UnsupportedOperationException(x.getMessage());
        }
        this.check(method, e);
    }

    @Override
    public boolean isTimingEnabled(MethodID method) throws NoSuchMethodException, ClassNotFoundException {
        MethodProfileEntry e = this.lookup(method);
        return e != null ? e.isTimingEnabled() : false;
    }

    @Override
    public MethodID[] getMethods(String fullyQualifiedClassName) throws ClassNotFoundException {
        Class<?> c = this.getFirstClass(fullyQualifiedClassName);
        ArrayList<MethodID> result = new ArrayList<MethodID>();
        for (Method m : c.getDeclaredMethods()) {
            int mods = m.getModifiers();
            if (Modifier.isNative(mods) || Modifier.isAbstract(mods)) continue;
            result.add(new MethodID(m));
        }
        return result.toArray(new MethodID[result.size()]);
    }

    @Override
    public long getExceptionCount(String throwableClass) throws ClassNotFoundException, ClassCastException {
        ExceptionProfileEntry e = this.lookup(throwableClass);
        return e != null ? (e.isCompositeEnabled() ? e.getCompositeCount() : e.getSingleCount()) : 0L;
    }

    @Override
    public boolean isExceptionCountEnabled(String throwableClass) throws ClassCastException, ClassNotFoundException {
        ExceptionProfileEntry e = this.lookup(throwableClass);
        return e != null ? e.isSingleEnabled() || e.isSingleEnabled() : false;
    }

    @Override
    public boolean isExceptionSubclassesCountEnabled(String throwableClass) throws ClassCastException, ClassNotFoundException {
        ExceptionProfileEntry e = this.lookup(throwableClass);
        return e != null ? e.isCompositeEnabled() || e.isCompositeEnabled() : false;
    }

    @Override
    public void setExceptionCountEnabled(String throwableClass, boolean enable, boolean includeAllSubclasses) throws ClassCastException, ClassNotFoundException, SecurityException {
        Profiler.checkControlAccess();
        ExceptionProfileEntry e = this.get(throwableClass);
        try {
            e.setSingleEnabled(enable);
            e.setCompositeEnabled(enable && includeAllSubclasses);
        }
        catch (NotAvailableException x) {
            throw new UnsupportedOperationException(x.getMessage());
        }
        this.check(throwableClass, e);
    }
}

