/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import sun.management.counter.Counter;

class PerfCounters
extends BeanBase
implements DynamicMBean {
    public static final String MBEAN_NAME = "oracle.jrockit.management:type=PerfCounters";
    private final MBeanInfo mbeanInfo = this.init();

    public PerfCounters(JVMManagement vmm) {
        super(vmm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getName() + " with null as attribute name.");
        }
        Counter c = this.vmm.getCounter(attribute);
        if (c != null) {
            Counter counter = c;
            synchronized (counter) {
                return c.getValue();
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getName() + " with null as attribute name.");
        }
        Counter c = this.vmm.getCounter(attribute.getName());
        if (c == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        throw new RuntimeOperationsException(new UnsupportedOperationException(), "Readonly attribute: " + attribute.getName());
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new NullPointerException());
        }
        AttributeList resultList = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                Object value = this.getAttribute(attributes[i]);
                resultList.add(new Attribute(attributes[i], value));
                continue;
            }
            catch (RuntimeOperationsException re) {
                throw re;
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e);
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new NullPointerException());
        }
        AttributeList resultList = new AttributeList();
        for (Attribute attr : attributes) {
            try {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                resultList.add(new Attribute(name, value));
            }
            catch (RuntimeOperationsException re) {
                throw re;
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e);
            }
            catch (Exception t) {
            }
        }
        return resultList;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new MBeanException(new Exception("This mbean does not expose any operations"));
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanInfo init() {
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] cInfo = new MBeanConstructorInfo[constructors.length];
        int i = 0;
        for (Constructor<?> constructor : constructors) {
            cInfo[i++] = new MBeanConstructorInfo("Constructor", constructor);
        }
        Collection<Counter> counters = this.vmm.getCounters();
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>(counters.size());
        for (Counter counter : counters) {
            if (counter.isVector()) continue;
            String typeName = "java.lang.String";
            Counter counter2 = counter;
            synchronized (counter2) {
                Object value = counter.getValue();
                if (value != null) {
                    typeName = value.getClass().getName();
                }
            }
            attributes.add(new MBeanAttributeInfo(counter.getName(), typeName, counter.getName() + " (" + counter.getUnits() + ")", true, false, false));
        }
        MBeanAttributeInfo[] aInfo = new MBeanAttributeInfo[attributes.size()];
        aInfo = attributes.toArray(aInfo);
        return new MBeanInfo(this.getClass().getName(), "An mbean exposing the available performance counters as attributes", aInfo, cInfo, null, null);
    }
}

