/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;

abstract class NotificationBeanBase
extends BeanBase
implements NotificationEmitter {
    private final NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    private int listenerCount;

    public NotificationBeanBase(JVMManagement mgmt) {
        super(mgmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notifier.addNotificationListener(listener, filter, handback);
        NotificationBeanBase notificationBeanBase = this;
        synchronized (notificationBeanBase) {
            if (this.listenerCount == 0) {
                this.onAddedFirst();
                ++this.listenerCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener, filter, handback);
        NotificationBeanBase notificationBeanBase = this;
        synchronized (notificationBeanBase) {
            if (--this.listenerCount == 0) {
                this.onAddedFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
        NotificationBeanBase notificationBeanBase = this;
        synchronized (notificationBeanBase) {
            if (--this.listenerCount == 0) {
                this.onAddedFirst();
            }
        }
    }

    public void sendNotification(Notification notification) {
        this.notifier.sendNotification(notification);
    }

    protected abstract void onAddedFirst();

    protected abstract void onRemovedLast();
}

