/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import java.io.Serializable;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodID
implements Serializable {
    private static final long serialVersionUID = 662364232346612L;
    private String className;
    private String methodName;
    private String paramTypes;
    private String returnType;
    private long classLoaderID;
    private int modifiers;
    private transient Method method;
    private transient String humanReadable;
    private transient String[] paramTypeNames;

    public MethodID(Method method) {
        this.method = method;
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        this.returnType = method.getReturnType().getName();
        this.paramTypes = MethodID.toParamString(method.getParameterTypes());
    }

    public MethodID(Method method, long classLoaderID) {
        this(method);
        this.classLoaderID = classLoaderID;
        this.modifiers = method.getModifiers();
    }

    private static String toParamString(Class<?>[] classes) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Class<?> c : classes) {
            if (!first) {
                buf.append(',');
            }
            buf.append(c.getName());
            first = false;
        }
        return buf.toString();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getReturnTypeName() {
        return this.returnType;
    }

    public String[] getParamTypeNames() {
        if (this.paramTypeNames == null) {
            this.paramTypeNames = this.paramTypes.split(",");
        }
        return this.paramTypeNames;
    }

    public String toString() {
        if (this.humanReadable == null) {
            this.humanReadable = this.returnType + " " + this.className + "." + this.methodName + "(" + this.paramTypes + ")" + " [CL=" + this.classLoaderID + "]";
        }
        return this.humanReadable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodID)) {
            return false;
        }
        MethodID other = (MethodID)obj;
        return other.className.equals(this.className) && other.methodName.equals(this.methodName) && other.paramTypes.equals(this.paramTypes) && other.returnType.equals(this.returnType);
    }

    public int hashCode() {
        return this.className.hashCode() | this.methodName.hashCode() | this.paramTypes.hashCode() | this.returnType.hashCode();
    }

    private boolean match(Method m) {
        return this.methodName.equals(m.getName()) && this.paramTypes.equals(MethodID.toParamString(m.getParameterTypes()));
    }

    Method getMethod(Class<?> c) throws NoSuchMethodException {
        if (this.method != null) {
            return this.method;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!this.match(m)) continue;
            this.method = m;
            return m;
        }
        throw new NoSuchMethodException(this.toString());
    }

    public long getClassLoaderID() {
        return this.classLoaderID;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

