/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.MemoryMBean;
import oracle.jrockit.management.VirtualMemoryUsageData;
import sun.management.MemoryUsageCompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Memory
extends BeanBase
implements MemoryMBean {
    private volatile long lastAcquireTime = 0L;
    private transient VirtualMemoryUsageData vmu;
    private transient CompositeType vmmType;

    public Memory(JVMManagement mgmt) {
        super(mgmt);
    }

    @Override
    public long getTotalPhysicalMemory() {
        return this.jvm.getMachine().getPhysicalMemory().getTotalMemory();
    }

    @Override
    public long getUsedPhysicalMemory() {
        return this.jvm.getMachine().getPhysicalMemory().getUsedMemory();
    }

    public void acquire() throws OpenDataException {
        long now;
        if (this.vmmType == null) {
            CompositeType t;
            CompositeData d = MemoryUsageCompositeData.toCompositeData(new MemoryUsage(0L, 0L, 0L, 0L));
            this.vmmType = t = new CompositeType("VirtualMemoryUsage", "Partition of virtual memory usage", new String[]{"name", "usage"}, new String[]{"Name of the partition", "Current usage"}, new OpenType[]{SimpleType.STRING, d.getCompositeType()});
        }
        if (((now = System.currentTimeMillis()) - this.lastAcquireTime) / 1000L > 1L) {
            this.lastAcquireTime = now;
            this.vmu = VirtualMemoryUsageData.get();
        }
    }

    @Override
    public List<CompositeData> getVirtualMemoryUsage() throws OpenDataException {
        this.acquire();
        Map<String, MemoryUsage> map = this.vmu.getUsageMap();
        ArrayList<CompositeData> l = new ArrayList<CompositeData>(map.size());
        for (Map.Entry<String, MemoryUsage> e : map.entrySet()) {
            l.add(new CompositeDataSupport(this.vmmType, new String[]{"name", "usage"}, new Object[]{e.getKey(), MemoryUsageCompositeData.toCompositeData(e.getValue())}));
        }
        return l;
    }
}

