/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.NotAvailableException;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.MemLeakMBean;
import sun.management.counter.Counter;
import sun.management.counter.LongArrayCounter;
import sun.management.counter.LongCounter;

class MemLeak
extends BeanBase
implements MemLeakMBean {
    private final LongArrayCounter mlsVersions;
    private final LongCounter mlsVersion;
    private final LongCounter mlsPort;
    private final DiagnosticCommand.Command startMLS;

    public MemLeak(JVMManagement mgmt) {
        super(mgmt);
        DiagnosticCommand.Command c1;
        Counter c = this.getCounter("jrockit.memleak.versions");
        if (c instanceof LongArrayCounter) {
            this.mlsVersions = (LongArrayCounter)c;
            this.mlsVersion = null;
        } else if (c instanceof LongCounter) {
            this.mlsVersions = null;
            this.mlsVersion = (LongCounter)c;
        } else {
            this.mlsVersions = null;
            this.mlsVersion = null;
        }
        this.mlsPort = (LongCounter)this.getCounter("jrockit.memleak.port");
        DiagnosticCommand dc = this.jvm.getDiagnosticCommand();
        try {
            c1 = dc.getCommand("memleakserver");
        }
        catch (NotAvailableException e) {
            c1 = null;
        }
        this.startMLS = c1;
    }

    public int[] getProtocolVersions() {
        if (this.mlsVersions != null) {
            long[] values = this.mlsVersions.longArrayValue();
            int[] res = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                res[i] = (int)values[i];
            }
            return res;
        }
        if (this.mlsVersion != null) {
            return new int[]{(int)this.mlsVersion.longValue()};
        }
        throw new UnsupportedOperationException();
    }

    public int getServerPort() {
        MemLeak.checkMonitorAccess();
        return (int)this.mlsPort.longValue();
    }

    public void shutDownServer() {
        MemLeak.checkControlAccess();
        if (this.startMLS == null) {
            throw new UnsupportedOperationException();
        }
        try {
            this.startMLS.execute("action=stop");
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException();
        }
    }

    public int startServer(int version, int port) throws IllegalAccessException, Exception {
        MemLeak.checkControlAccess();
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        if (this.startMLS == null) {
            throw new UnsupportedOperationException();
        }
        try {
            this.startMLS.execute("action=start force=true version=" + version + " port=" + port);
        }
        catch (RuntimeException e) {
            this.rethrowUnwrapped(e);
        }
        return this.getServerPort();
    }
}

