/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.LoggingModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.LogMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log
extends BeanBase
implements LogMBean {
    private final HashMap<String, LoggingModule> modules = new HashMap();
    private static final String[] ITEM_NAMES = new String[]{"name", "aliases", "defaultlevel"};
    private static final CompositeType COMPOSITE_TYPE;

    public Log(JVMManagement mgmt) {
        super(mgmt);
        for (LoggingModule loggingModule : this.jvm.getLoggingSystem().getModules()) {
            this.modules.put(loggingModule.getName(), loggingModule);
            for (String s : loggingModule.getAliases()) {
                this.modules.put(s, loggingModule);
            }
        }
    }

    private LoggingModule getModule(String name) {
        return this.modules.get(name);
    }

    @Override
    public String getLevel(String name) {
        return this.getModule(name).getLevel();
    }

    private String[] aliases(LoggingModule module) {
        Collection<String> c = module.getAliases();
        String[] res = new String[c.size()];
        int n = 0;
        Iterator<String> i = c.iterator();
        while (i.hasNext()) {
            res[n++] = i.next();
        }
        return res;
    }

    @Override
    public List<String> getLogModuleNames() {
        ArrayList<String> res = new ArrayList<String>(this.modules.size());
        for (LoggingModule m : this.modules.values()) {
            res.add(m.getName());
        }
        return res;
    }

    @Override
    public CompositeData getLogModuleInfo(String name) {
        LoggingModule module = this.getModule(name);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{module.getName(), this.aliases(module), module.getDefaultLevel()});
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @Override
    public List<String> getLevels() {
        return this.jvm.getLoggingSystem().getLevels();
    }

    @Override
    public void setLevel(String name, String level) {
        this.getModule(name).setLevel(level);
    }

    static {
        CompositeType myType = null;
        try {
            myType = new CompositeType("LogModule", "Information about a log module.", ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.STRING, new ArrayType(1, SimpleType.STRING), SimpleType.STRING});
        }
        catch (OpenDataException e) {
            throw new InternalError("Could not create the LogModule composite type: " + e.getMessage());
        }
        COMPOSITE_TYPE = myType;
    }
}

