/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.JVM;
import com.bea.jvm.JVMFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import sun.management.ManagementFactory;
import sun.management.VMManagement;
import sun.management.counter.Counter;
import sun.management.counter.LongCounter;
import sun.management.counter.Units;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JVMManagement
implements VMManagement {
    private final VMManagement vmm;
    private final HashMap<String, Counter> counterMap;
    private final JVM jvm;
    private static Method isObjectMonitorUsageSupported;
    private static Method isSynchronizerUsageSupported;
    private final double ticksPerMillis;
    private final double ticksPerNanos;

    public JVMManagement(JVM jvm, VMManagement vmm) throws Exception {
        this.jvm = jvm;
        if (vmm == null) {
            Field f = ManagementFactory.class.getDeclaredField("jvm");
            f.setAccessible(true);
            vmm = (VMManagement)f.get(null);
        }
        this.vmm = vmm;
        List counters = vmm.getInternalCounters(".*");
        HashMap<String, Counter> map = new HashMap<String, Counter>();
        for (Counter c : counters) {
            map.put(c.getName(), c);
        }
        this.counterMap = map;
        LongCounter ticks = (LongCounter)this.getAnyCounter("rt.counterFrequency");
        if (ticks == null) {
            throw new InternalError("require counter not found");
        }
        this.ticksPerNanos = ticks.longValue() / 1000000000L;
        this.ticksPerMillis = ticks.longValue() / 1000L;
    }

    public JVMManagement() throws Exception {
        this(JVMFactory.getJVM(), null);
    }

    public JVM getJVM() {
        return this.jvm;
    }

    public VMManagement getVMManagement() {
        return this.vmm;
    }

    @Override
    public int getAvailableProcessors() {
        return this.vmm.getAvailableProcessors();
    }

    @Override
    public String getBootClassPath() {
        return this.vmm.getBootClassPath();
    }

    @Override
    public long getClassInitializationTime() {
        return this.vmm.getClassInitializationTime();
    }

    @Override
    public long getClassLoadingTime() {
        return this.vmm.getClassLoadingTime();
    }

    @Override
    public String getClassPath() {
        return this.vmm.getClassPath();
    }

    @Override
    public long getClassVerificationTime() {
        return this.vmm.getClassVerificationTime();
    }

    @Override
    public String getCompilerName() {
        return this.vmm.getCompilerName();
    }

    @Override
    public int getDaemonThreadCount() {
        return this.vmm.getDaemonThreadCount();
    }

    @Override
    public long getInitializedClassCount() {
        return this.vmm.getInitializedClassCount();
    }

    @Override
    public List<?> getInternalCounters(String arg0) {
        return this.vmm.getInternalCounters(arg0);
    }

    @Override
    public String getLibraryPath() {
        return this.vmm.getLibraryPath();
    }

    @Override
    public int getLiveThreadCount() {
        return this.vmm.getLiveThreadCount();
    }

    @Override
    public int getLoadedClassCount() {
        return this.vmm.getLoadedClassCount();
    }

    @Override
    public long getLoadedClassSize() {
        return this.vmm.getLoadedClassSize();
    }

    @Override
    public String getManagementVersion() {
        return this.vmm.getManagementVersion();
    }

    @Override
    public long getMethodDataSize() {
        return this.vmm.getMethodDataSize();
    }

    @Override
    public String getOsArch() {
        return this.vmm.getOsArch();
    }

    @Override
    public String getOsName() {
        return this.vmm.getOsName();
    }

    @Override
    public String getOsVersion() {
        return this.vmm.getOsVersion();
    }

    @Override
    public int getPeakThreadCount() {
        return this.vmm.getPeakThreadCount();
    }

    @Override
    public long getSafepointCount() {
        return this.vmm.getSafepointCount();
    }

    @Override
    public long getSafepointSyncTime() {
        return this.vmm.getSafepointSyncTime();
    }

    @Override
    public long getStartupTime() {
        return this.vmm.getStartupTime();
    }

    @Override
    public long getTotalApplicationNonStoppedTime() {
        return this.vmm.getTotalApplicationNonStoppedTime();
    }

    @Override
    public long getTotalClassCount() {
        return this.vmm.getTotalClassCount();
    }

    @Override
    public long getTotalCompileTime() {
        return this.vmm.getTotalCompileTime();
    }

    @Override
    public long getTotalSafepointTime() {
        return this.vmm.getTotalSafepointTime();
    }

    @Override
    public long getTotalThreadCount() {
        return this.vmm.getTotalThreadCount();
    }

    @Override
    public long getUnloadedClassCount() {
        return this.vmm.getUnloadedClassCount();
    }

    @Override
    public long getUnloadedClassSize() {
        return this.vmm.getUnloadedClassSize();
    }

    @Override
    public boolean getVerboseClass() {
        return this.vmm.getVerboseClass();
    }

    @Override
    public boolean getVerboseGC() {
        return this.vmm.getVerboseGC();
    }

    @Override
    public List<String> getVmArguments() {
        return this.vmm.getVmArguments();
    }

    @Override
    public String getVmId() {
        return this.vmm.getVmId();
    }

    @Override
    public String getVmName() {
        return this.vmm.getVmName();
    }

    @Override
    public String getVmSpecName() {
        return this.vmm.getVmSpecName();
    }

    @Override
    public String getVmSpecVendor() {
        return this.vmm.getVmSpecVendor();
    }

    @Override
    public String getVmSpecVersion() {
        return this.vmm.getVmSpecVersion();
    }

    @Override
    public String getVmVendor() {
        return this.vmm.getVmVendor();
    }

    @Override
    public String getVmVersion() {
        return this.vmm.getVmVersion();
    }

    @Override
    public boolean isBootClassPathSupported() {
        return this.vmm.isBootClassPathSupported();
    }

    @Override
    public boolean isCompilationTimeMonitoringSupported() {
        return this.vmm.isCompilationTimeMonitoringSupported();
    }

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.vmm.isCurrentThreadCpuTimeSupported();
    }

    @Override
    public boolean isOtherThreadCpuTimeSupported() {
        return this.vmm.isOtherThreadCpuTimeSupported();
    }

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        return this.vmm.isThreadContentionMonitoringEnabled();
    }

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.vmm.isThreadContentionMonitoringSupported();
    }

    @Override
    public boolean isThreadCpuTimeEnabled() {
        return this.vmm.isThreadCpuTimeEnabled();
    }

    private static void initReflection() {
        try {
            Class<VMManagement> c = VMManagement.class;
            isObjectMonitorUsageSupported = c.getMethod("isObjectMonitorUsageSupported", new Class[0]);
            isObjectMonitorUsageSupported.setAccessible(true);
            isSynchronizerUsageSupported = c.getMethod("isSynchronizerUsageSupported", new Class[0]);
            isSynchronizerUsageSupported.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        try {
            if (isObjectMonitorUsageSupported != null) {
                return (Boolean)isObjectMonitorUsageSupported.invoke(this.vmm, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isSynchronizerUsageSupported() {
        try {
            if (isSynchronizerUsageSupported != null) {
                return (Boolean)isSynchronizerUsageSupported.invoke(this.vmm, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Counter getCounter(String name) {
        return this.counterMap.get(name);
    }

    public Counter getAnyCounter(String extension) {
        for (String s : this.counterMap.keySet()) {
            if (!s.endsWith(extension)) continue;
            return this.counterMap.get(s);
        }
        return null;
    }

    public Collection<Counter> getCounters() {
        return this.counterMap.values();
    }

    public long ticksToMillis(LongCounter c) {
        if (c == null) {
            return 0L;
        }
        assert (c.getUnits() == Units.TICKS);
        return (long)((double)c.longValue() / this.ticksPerMillis);
    }

    public long ticksToNanos(LongCounter c) {
        if (c == null) {
            return 0L;
        }
        assert (c.getUnits() == Units.TICKS);
        return (long)((double)c.longValue() / this.ticksPerNanos);
    }

    static {
        JVMManagement.initReflection();
    }
}

