/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.oracle.jrockit.jfr.FlightRecorder;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.Compilation;
import oracle.jrockit.management.DiagnosticCommand;
import oracle.jrockit.management.GarbageCollector;
import oracle.jrockit.management.HSBridge;
import oracle.jrockit.management.HSBridgeUnsupported;
import oracle.jrockit.management.JRockitConsoleMBean;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.Log;
import oracle.jrockit.management.MemLeak;
import oracle.jrockit.management.Memory;
import oracle.jrockit.management.PerfCounters;
import oracle.jrockit.management.Profiler;
import oracle.jrockit.management.Runtime;
import oracle.jrockit.management.Threading;
import oracle.jrockit.management.server.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRockitConsole
extends BeanBase
implements JRockitConsoleMBean,
MBeanRegistration {
    private MBeanServer server;
    private final List<BeanBase> beans = new ArrayList<BeanBase>();
    private final LinkedList<ObjectInstance> registered = new LinkedList();
    private final HSBridge hsBridge;
    private boolean registeredFlightRecorder;

    public JRockitConsole() throws Exception {
        this(new JVMManagement());
    }

    public JRockitConsole(JVMManagement mgmt) {
        super(mgmt);
        this.beans.add(new Compilation(mgmt));
        this.beans.add(new DiagnosticCommand(mgmt));
        this.beans.add(new GarbageCollector(mgmt));
        this.beans.add(new Log(mgmt));
        this.beans.add(new MemLeak(mgmt));
        this.beans.add(new Memory(mgmt));
        this.beans.add(new PerfCounters(mgmt));
        this.beans.add(new Profiler(mgmt));
        this.beans.add(new Runtime(mgmt));
        this.beans.add(new Threading(mgmt));
        HSBridge h = null;
        try {
            h = HSBridge.getHSBridge(mgmt.getVMManagement());
        }
        catch (Exception e) {
            Messages.error(e);
            h = new HSBridgeUnsupported();
        }
        this.hsBridge = h;
    }

    @Override
    public int getAPIVersion() {
        return 65536;
    }

    @Override
    public boolean isAssignableFrom(String typeName, String subTypeName) throws ClassNotFoundException {
        ClassLoader l = this.getClass().getClassLoader();
        Class<?> type = null;
        Class<?> c = null;
        try {
            c = Class.forName(subTypeName, false, l);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            type = Class.forName(typeName, false, l);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (c == null) {
            c = this.jvm.getClassLibrary().getAllClasses(subTypeName).iterator().next();
        }
        if (type == null) {
            type = this.jvm.getClassLibrary().getAllClasses(typeName).iterator().next();
        }
        return type.isAssignableFrom(c);
    }

    @Override
    public long getSystemTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long getSystemTimeNanos() {
        return System.nanoTime();
    }

    @Override
    public boolean isExitOnOutOfMemory() {
        JRockitConsole.checkMonitorAccess();
        return this.jvm.getMemorySystem().isExitOnOutOfMemory();
    }

    @Override
    public void setExitOnOutOfMemory(boolean exitOnOOM) throws SecurityException {
        JRockitConsole.checkControlAccess();
        this.jvm.getMemorySystem().setExitOnOutOfMemory(exitOnOOM);
    }

    @Override
    public void dumpHeap(String outputFile, boolean live) throws IOException, UnsupportedOperationException {
        this.hsBridge.dumpHeap(outputFile, live);
    }

    @Override
    public List<CompositeData> getDiagnosticOptions() throws UnsupportedOperationException {
        return this.hsBridge.getDiagnosticOptions();
    }

    @Override
    public CompositeData getVMOption(String name) throws UnsupportedOperationException {
        return this.hsBridge.getVMOption(name);
    }

    @Override
    public void setVMOption(String name, String value) throws UnsupportedOperationException {
        this.hsBridge.setVMOption(name, value);
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, InstanceNotFoundException {
                for (ObjectInstance o : JRockitConsole.this.registered) {
                    JRockitConsole.this.server.unregisterMBean(o.getObjectName());
                }
                if (JRockitConsole.this.registeredFlightRecorder) {
                    FlightRecorder.unregisterWithMBeanServer(JRockitConsole.this.server);
                }
                return null;
            }
        });
    }

    @Override
    public ObjectName preRegister(final MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
                for (BeanBase b : JRockitConsole.this.beans) {
                    try {
                        JRockitConsole.this.registered.add(server.registerMBean(b, b.getName()));
                    }
                    catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {}
                }
                if (!server.isRegistered(new ObjectName("com.oracle.jrockit:type=FlightRecorder")) && FlightRecorder.isActive()) {
                    FlightRecorder.registerWithMBeanServer(server);
                    JRockitConsole.this.registeredFlightRecorder = true;
                }
                return null;
            }
        });
        return this.getName();
    }
}

