/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeData;
import oracle.jrockit.management.HSBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HSBridge60
extends HSBridge {
    private final Object hsDiagnostics;
    private final Method dumpHeap;
    private final Method getDiagnosticOptions;
    private final Method getVMOption;
    private final Method setVMOption;
    private Method toVMOptionCompositeData;

    HSBridge60(Class<?> c) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        this.hsDiagnostics = c.newInstance();
        this.dumpHeap = c.getMethod("dumpHeap", String.class, Boolean.TYPE);
        this.getDiagnosticOptions = c.getMethod("getDiagnosticOptions", new Class[0]);
        this.getVMOption = c.getMethod("getVMOption", String.class);
        this.setVMOption = c.getMethod("setVMOption", String.class, String.class);
    }

    @Override
    void dumpHeap(String outputFile, boolean live) throws IOException {
        try {
            this.dumpHeap.invoke(this.hsDiagnostics, outputFile, live);
        }
        catch (Exception e) {
            throw (IOException)new UnsupportedOperationException(e).initCause(e);
        }
    }

    private CompositeData toVMOptionCompositeData(Object o) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (o == null) {
            return null;
        }
        if (this.toVMOptionCompositeData == null) {
            Class<?> c = Class.forName("sun.management.VMOptionCompositeData", false, null);
            this.toVMOptionCompositeData = c.getMethod("toCompositeData", o.getClass());
        }
        return (CompositeData)this.toVMOptionCompositeData.invoke(null, o);
    }

    @Override
    List<CompositeData> getDiagnosticOptions() {
        ArrayList<CompositeData> l = new ArrayList<CompositeData>();
        try {
            List opts = (List)this.getDiagnosticOptions.invoke(this.hsDiagnostics, new Object[0]);
            if (opts.size() > 0) {
                for (Object o : opts) {
                    l.add(this.toVMOptionCompositeData(o));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return l;
    }

    @Override
    CompositeData getVMOption(String name) {
        try {
            return this.toVMOptionCompositeData(this.getVMOption.invoke(this.hsDiagnostics, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void setVMOption(String name, String value) {
        try {
            this.setVMOption.invoke(this.hsDiagnostics, name, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

