/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.DiagnosticCommand;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.management.HSBridge;
import sun.management.Flag;
import sun.management.VMManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HSBridge50
extends HSBridge {
    private final Object hsRuntime;
    private final CompositeType flagType;
    private final Method getInternalFlags;
    private final Method getFlag;

    HSBridge50(VMManagement vmm, Class<?> c) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, OpenDataException {
        Constructor<?> cc = c.getDeclaredConstructor(VMManagement.class);
        cc.setAccessible(true);
        this.hsRuntime = cc.newInstance(vmm);
        this.getInternalFlags = c.getMethod("getInternalFlags", new Class[0]);
        this.getInternalFlags.setAccessible(true);
        this.getFlag = c.getMethod("getFlag", String.class);
        this.getFlag.setAccessible(true);
        this.flagType = new CompositeType("VMFlag", "JVM Flag", new String[]{"name", "value"}, new String[]{"Name", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
    }

    @Override
    void dumpHeap(String outputFile, boolean live) throws IOException, UnsupportedOperationException {
        DiagnosticCommand.getDiagnosticCommand().executeDefault("hprofdump", "filename=\"" + outputFile + "\"");
    }

    private CompositeData toCompositeData(Flag f) throws OpenDataException {
        if (f == null) {
            return null;
        }
        return new CompositeDataSupport(this.flagType, new String[]{"name", "value"}, new Object[]{f.getName(), String.valueOf(f.getValue())});
    }

    @Override
    List<CompositeData> getDiagnosticOptions() {
        try {
            List flags = (List)this.getInternalFlags.invoke(this.hsRuntime, new Object[0]);
            ArrayList<CompositeData> res = new ArrayList<CompositeData>();
            for (Flag f : flags) {
                if (!f.isWriteable()) continue;
                res.add(this.toCompositeData(f));
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    CompositeData getVMOption(String name) {
        try {
            return this.toCompositeData((Flag)this.getFlag.invoke(this.hsRuntime, name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void setVMOption(String name, String value) throws UnsupportedOperationException {
        DiagnosticCommand.getDiagnosticCommand().executeDefault("set_vmflag", "flag=" + name + " value=\"" + value + "\"");
    }
}

