/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.GarbageCollectionHeuristic;
import com.bea.jvm.GarbageCollectionStrategy;
import com.bea.jvm.MemorySystem;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import com.bea.jvm.event.GarbageCollectionStrategyChangeEvent;
import com.bea.jvm.event.GarbageCollectionStrategyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.management.GarbageCollectorMBean;
import oracle.jrockit.management.JVMManagement;
import oracle.jrockit.management.NotificationBeanBase;
import sun.management.counter.Counter;
import sun.management.counter.LongCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GarbageCollector
extends NotificationBeanBase
implements GarbageCollectorMBean,
GarbageCollectionStrategyChangeListener,
GarbageCollectionListener {
    private final AtomicLong sequence = new AtomicLong();
    private final GCCounters ycInfo;
    private final GCCounters ocInfo;
    private final ObjectName objectName;
    private final MemoryMXBean membean;
    private final com.bea.jvm.GarbageCollector gc;
    private final MemorySystem memsystem;
    private transient GarbageCollectionHeuristic cachedHeuristic;
    private transient CompositeData currentHeuristic;
    private transient GarbageCollectionStrategy cachedStrategy;
    private transient CompositeData currentStrategy;
    private final MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"oracle.jrockit.management.garbage_collector_strategy_change", "oracle.jrockit.management.garbage_collection"}, "oracle.jrockit.management.Notification", "Garbage collection event notification")};
    private static final String KEY_NAME = "name";
    private static final String KEY_DESCRIPTION = "description";
    private static final String[] namedTypeOpenNames = new String[]{"name", "description"};
    private static final String[] gcEventOpenNames = new String[]{"startTime", "endTime", "isMajorGC", "oldHeap", "newHeap", "maxHeap", "startPageFaults", "endPageFaults"};
    private final CompositeType namedItemOpenType;
    private final CompositeType gcEventOpenType;

    public GarbageCollector(JVMManagement mgmt, MemoryMXBean membean) {
        super(mgmt);
        GCCounters yc;
        GCCounterImpl oc;
        try {
            oc = new GCCounterImpl(this.getGCCounter("pool.heap.beforeGC.used"), this.getGCCounter("pool.heap.afterGC.used"), this.getGCCounter("pool.heap.max"), this.getGCCounter("mgr.latest.oc.start.pageFaults"), this.getGCCounter("mgr.latest.oc.end.pageFaults"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            yc = new GCCounterImpl(this.getGCCounter("pool.nursery.beforeGC.used"), this.getGCCounter("pool.nursery.afterGC.used"), this.getGCCounter("pool.nursery.max"), this.getGCCounter("mgr.latest.yc.start.pageFaults"), this.getGCCounter("mgr.latest.yc.end.pageFaults"));
        }
        catch (Throwable t) {
            yc = new DummyGCCounters();
        }
        this.ocInfo = oc;
        this.ycInfo = yc;
        try {
            this.objectName = new ObjectName("oracle.jrockit.management:type=GarbageCollector");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.membean = membean;
        this.memsystem = this.jvm.getMemorySystem();
        this.gc = this.memsystem.getGarbageCollector();
        CompositeType myType = null;
        CompositeType gcType = null;
        try {
            myType = new CompositeType("Named Item", "Named Item", namedTypeOpenNames, namedTypeOpenNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            gcType = new CompositeType("oracle.jrockit.management.garbage_collection", "Garbage collection callback event", gcEventOpenNames, gcEventOpenNames, new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        this.namedItemOpenType = myType;
        this.gcEventOpenType = gcType;
    }

    public GarbageCollector(JVMManagement mgmt) {
        this(mgmt, ManagementFactory.getMemoryMXBean());
    }

    private LongCounter getGCCounter(String extension) {
        for (String s : new String[]{"gc.", ""}) {
            try {
                Counter c = this.getCounter("oracle." + s + extension);
                if (c != null) {
                    return (LongCounter)c;
                }
                c = this.getCounter("jrockit." + s + extension);
                if (c == null) continue;
                return (LongCounter)c;
            }
            catch (ClassCastException e) {
                throw new InternalError(e.getMessage());
            }
        }
        throw new InternalError("required counter not found : " + extension);
    }

    @Override
    public long getAllocatedHeapSize() {
        return this.membean.getHeapMemoryUsage().getCommitted();
    }

    @Override
    public String getHeuristic() {
        GarbageCollectionHeuristic gch = this.gc.getGarbageCollectionHeuristic();
        if (this.cachedHeuristic != gch) {
            this.currentHeuristic = this.createNamedItem(gch.getName(), gch.getDescription());
            this.cachedHeuristic = gch;
        }
        return (String)this.currentHeuristic.get(KEY_NAME);
    }

    @Override
    public long getMaxPauseTimeTarget() {
        return this.gc.getMaxPauseTimeTarget();
    }

    @Override
    public long getMinPauseTimeTarget() {
        return this.gc.getMinPauseTimeTarget();
    }

    @Override
    public long getNurserySize() {
        try {
            return this.gc.getNurserySize();
        }
        catch (NotAvailableException na) {
            return 0L;
        }
    }

    @Override
    public long getPauseTimeTarget() {
        return this.gc.getPauseTimeTarget();
    }

    @Override
    public String getStrategy() {
        GarbageCollectionStrategy gcs = this.gc.getGarbageCollectionStrategy();
        if (this.cachedStrategy == null || !this.cachedStrategy.equals(gcs)) {
            this.currentStrategy = this.createNamedItem(gcs.getDescription(), gcs.getStrategyProperties().toString());
            this.cachedStrategy = gcs;
        }
        return (String)this.currentStrategy.get(KEY_NAME);
    }

    @Override
    public boolean isHeapSizeLocked() {
        return this.memsystem.isHeapSizeLocked();
    }

    @Override
    public void setAllocatedHeapSizeTarget(long heapSize) throws SecurityException {
        GarbageCollector.checkControlAccess();
        this.memsystem.suggestHeapSize(heapSize);
    }

    @Override
    public long getAllocatedHeapSizeTarget() throws SecurityException {
        return this.memsystem.getSuggestedHeapSize();
    }

    @Override
    public void setHeapSizeLocked(boolean locked) throws SecurityException {
        GarbageCollector.checkControlAccess();
        this.memsystem.setHeapSizeLocked(locked);
    }

    @Override
    public void setNurserySize(long nurserySize) {
        GarbageCollector.checkControlAccess();
        try {
            this.gc.setNurserySize(nurserySize);
        }
        catch (NotAvailableException notAvailableException) {
            // empty catch block
        }
    }

    @Override
    public void setPauseTimeTarget(long target) throws IllegalAccessException {
        GarbageCollector.checkControlAccess();
        try {
            this.gc.setPauseTimeTarget(target);
        }
        catch (IllegalStateException e) {
            IllegalAccessException accessException = new IllegalAccessException(e.getMessage());
            accessException.initCause(e);
            throw accessException;
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
    }

    @Override
    public void setStrategy(String name) {
        GarbageCollector.checkControlAccess();
        try {
            for (GarbageCollectionStrategy s : this.gc.getGarbageCollectionStrategies()) {
                if (!s.getDescription().equals(name)) continue;
                this.gc.suggestGarbageCollectionStrategy(s);
                return;
            }
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        throw new UnsupportedOperationException("Could not find a strategy with the description " + name);
    }

    @Override
    public void setHeuristic(String name) {
        GarbageCollector.checkControlAccess();
        try {
            for (GarbageCollectionHeuristic h : this.gc.getGarbageCollectionHeuristics()) {
                if (!h.getName().equals(name)) continue;
                this.gc.suggestGarbageCollectionHeuristic(h);
                return;
            }
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        throw new UnsupportedOperationException("Could not find a heuristic with the name " + name);
    }

    @Override
    public List<CompositeData> getStrategies() {
        GarbageCollector.checkMonitorAccess();
        ArrayList<CompositeData> names = new ArrayList<CompositeData>();
        for (GarbageCollectionStrategy s : this.gc.getGarbageCollectionStrategies()) {
            names.add(this.createNamedItem(s.getDescription(), s.getStrategyProperties().toString()));
        }
        return names;
    }

    @Override
    public void gc() {
        this.gc.gc();
    }

    @Override
    protected void onAddedFirst() {
        GarbageCollector.checkMonitorAccess();
        com.bea.jvm.GarbageCollector gc = this.jvm.getMemorySystem().getGarbageCollector();
        gc.addGarbageCollectionListener(this);
        gc.addGarbageCollectionStrategyChangeListener(this);
    }

    @Override
    protected void onRemovedLast() {
        com.bea.jvm.GarbageCollector gc = this.jvm.getMemorySystem().getGarbageCollector();
        gc.removeGarbageCollectionListener(this);
        gc.removeGarbageCollectionStrategyChangeListener(this);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifications;
    }

    @Override
    public void onGarbageCollection(GarbageCollectionEvent event) {
        GCCounters info;
        boolean isMajor;
        if (event.getEventType() == 0) {
            isMajor = true;
            info = this.ocInfo;
        } else {
            isMajor = false;
            info = this.ycInfo;
        }
        Notification notif = new Notification("oracle.jrockit.management.garbage_collection", this.objectName, this.sequence.incrementAndGet(), event.getEndTime(), "Garbage collection");
        notif.setUserData(this.createGCInfo(event.getStartTime(), event.getEndTime(), isMajor, info.getOldUsedHeapSize(), info.getUsedHeapSize(), info.getMaxHeapSize(), info.getStartPageFaults(), info.getEndPageFaults()));
        this.sendNotification(notif);
    }

    @Override
    public void onGarbageCollectionStrategyChange(GarbageCollectionStrategyChangeEvent event) {
        Notification notif = new Notification("oracle.jrockit.management.garbage_collector_strategy_change", this.objectName, this.sequence.incrementAndGet(), event.getTime(), "Garbage Collector strategy changed");
        GarbageCollectionStrategy s = event.getNext();
        notif.setUserData(this.createNamedItem(s.getDescription(), s.getStrategyProperties().toString()));
        this.sendNotification(notif);
    }

    @Override
    public List<CompositeData> getHeuristics() {
        GarbageCollector.checkMonitorAccess();
        ArrayList<CompositeData> names = new ArrayList<CompositeData>();
        for (GarbageCollectionHeuristic h : this.gc.getGarbageCollectionHeuristics()) {
            names.add(this.createNamedItem(h.getName(), h.getDescription()));
        }
        return names;
    }

    private CompositeData createNamedItem(String name, String description) {
        try {
            return new CompositeDataSupport(this.namedItemOpenType, namedTypeOpenNames, new Object[]{name, description});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    private CompositeData createGCInfo(long startTime, long endTime, boolean isMajorGC, long oldHeapSize, long newHeapSize, long maxHeapSize, long startPageFaults, long endPageFaults) {
        try {
            return new CompositeDataSupport(this.gcEventOpenType, gcEventOpenNames, new Object[]{startTime, endTime, isMajorGC, oldHeapSize, newHeapSize, maxHeapSize, startPageFaults, endPageFaults});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    static final class DummyGCCounters
    extends GCCounters {
        DummyGCCounters() {
        }

        public long getEndPageFaults() {
            return 0L;
        }

        public long getMaxHeapSize() {
            return 0L;
        }

        public long getOldUsedHeapSize() {
            return 0L;
        }

        public long getStartPageFaults() {
            return 0L;
        }

        public long getUsedHeapSize() {
            return 0L;
        }
    }

    static final class GCCounterImpl
    extends GCCounters {
        private final LongCounter oldHeap;
        private final LongCounter usedHeap;
        private final LongCounter maxHeap;
        final LongCounter startPageFaults;
        final LongCounter endPageFaults;

        public GCCounterImpl(LongCounter oldHeap, LongCounter usedHeap, LongCounter maxHeap, LongCounter startPageFaults, LongCounter endPageFaults) {
            this.oldHeap = oldHeap;
            this.usedHeap = usedHeap;
            this.maxHeap = maxHeap;
            this.startPageFaults = startPageFaults;
            this.endPageFaults = endPageFaults;
        }

        public long getOldUsedHeapSize() {
            return this.oldHeap.longValue();
        }

        public long getUsedHeapSize() {
            return this.usedHeap.longValue();
        }

        public long getMaxHeapSize() {
            return this.maxHeap.longValue();
        }

        public long getStartPageFaults() {
            return this.startPageFaults.longValue();
        }

        public long getEndPageFaults() {
            return this.endPageFaults.longValue();
        }
    }

    static abstract class GCCounters {
        GCCounters() {
        }

        public abstract long getOldUsedHeapSize();

        public abstract long getUsedHeapSize();

        public abstract long getMaxHeapSize();

        public abstract long getStartPageFaults();

        public abstract long getEndPageFaults();
    }
}

