/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.DiagnosticCommand;
import com.bea.jvm.NotAvailableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.management.BeanBase;
import oracle.jrockit.management.DiagnosticCommandMBean;
import oracle.jrockit.management.JVMManagement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiagnosticCommand
extends BeanBase
implements DiagnosticCommandMBean {
    private static final String[] paramOpenNames = new String[]{"command", "name", "description", "isRequired", "type", "defaultValue"};
    private final CompositeType paramOpenType;

    public DiagnosticCommand(JVMManagement mgmt) {
        super(mgmt);
        CompositeType myType = null;
        try {
            myType = new CompositeType("Diagnostic Command Parameters", "Diagnostic Command Parameters", paramOpenNames, paramOpenNames, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.INTEGER, SimpleType.STRING});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        this.paramOpenType = myType;
    }

    private com.bea.jvm.DiagnosticCommand target() {
        return this.jvm.getDiagnosticCommand();
    }

    @Override
    public String execute(String command) {
        DiagnosticCommand.checkControlAccess();
        try {
            return this.target().execute(command);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String execute(String command, String params) {
        DiagnosticCommand.checkControlAccess();
        try {
            return this.target().execute(command, params);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String execute(String command, Map<String, Object> params) {
        DiagnosticCommand.checkControlAccess();
        try {
            return this.target().execute(command, params);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void executeDefault(String command) {
        DiagnosticCommand.checkControlAccess();
        try {
            this.target().executeDefault(command);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void executeDefault(String command, String params) {
        DiagnosticCommand.checkControlAccess();
        try {
            this.target().executeDefault(command, params);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void executeDefault(String command, Map<String, Object> params) {
        DiagnosticCommand.checkControlAccess();
        try {
            this.target().executeDefault(command, params);
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public List<String> getAllCommands() {
        DiagnosticCommand.checkMonitorAccess();
        ArrayList<String> l = new ArrayList<String>();
        for (DiagnosticCommand.Command c : this.target().getCommands()) {
            l.add(c.getName());
        }
        return l;
    }

    @Override
    public String getHelp(String command) {
        DiagnosticCommand.checkMonitorAccess();
        try {
            return this.target().getCommand(command).help();
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public String getDescription(String command) {
        DiagnosticCommand.checkMonitorAccess();
        try {
            return this.target().getCommand(command).getDescription();
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Collection<CompositeData> getParameters(String command) {
        DiagnosticCommand.checkMonitorAccess();
        try {
            Collection<DiagnosticCommand.Parameter> params = this.target().getCommand(command).getParameters();
            ArrayList<CompositeData> res = new ArrayList<CompositeData>(params.size());
            for (DiagnosticCommand.Parameter p : params) {
                res.add(new CompositeDataSupport(this.paramOpenType, paramOpenNames, new Object[]{command, p.getName(), p.getDescription(), p.isRequired(), p.getType(), String.valueOf(p.getDefaultValue())}));
            }
            return res;
        }
        catch (NotAvailableException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

