/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.management.counter.Counter;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Counters {
    private static Counters instance;
    private final int vmid;
    private PerfInstrumentation perfInstr = null;
    private boolean noPerfData = false;
    private List<Counter> counters;

    private Counters(int vmid) {
        this.vmid = vmid;
        this.perfInstr = this.getPerfInstrumentation(vmid);
    }

    private synchronized PerfInstrumentation getPerfInstrumentation(int vmid) {
        if (this.noPerfData || this.perfInstr != null) {
            return this.perfInstr;
        }
        Perf perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
        try {
            ByteBuffer bb = perf.attach(vmid, "r");
            if (bb.capacity() == 0) {
                this.noPerfData = true;
                return null;
            }
            this.perfInstr = new PerfInstrumentation(bb);
        }
        catch (IllegalArgumentException e) {
            this.noPerfData = true;
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
        return this.perfInstr;
    }

    public static Counters acquire() {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        if (instance == null) {
            instance = new Counters(0);
        }
        return instance;
    }

    public static Counters acquire(int vmid) {
        if (vmid == 0) {
            return Counters.acquire();
        }
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPermission(new AllPermission());
        }
        return new Counters(vmid);
    }

    public synchronized List<Counter> getPerformanceCounters(boolean flush) {
        if (this.counters == null || flush) {
            if (this.perfInstr == null) {
                this.counters = Collections.emptyList();
                return this.counters;
            }
            this.counters = Collections.unmodifiableList(this.perfInstr.getAllCounters());
        }
        return this.counters;
    }

    public synchronized List<Counter> getPerformanceCounters() {
        return this.getPerformanceCounters(false);
    }

    public Counter getPerformanceCounter(String name) {
        for (Counter c : this.getPerformanceCounters()) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public List<Counter> findPerformanceCounters(String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher("");
        ArrayList<Counter> res = new ArrayList<Counter>();
        for (Counter c : this.getPerformanceCounters()) {
            String name = c.getName();
            m.reset(name);
            if (!m.lookingAt()) continue;
            res.add(c);
        }
        return res;
    }

    public String toString() {
        return "Performance counters (" + this.vmid + ")";
    }
}

