/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.management;

import com.bea.jvm.JVM;
import java.lang.management.ManagementPermission;
import java.security.Permission;
import javax.management.ObjectName;
import oracle.jrockit.management.JVMManagement;
import sun.management.counter.Counter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BeanBase {
    static final String NS_JROCKIT = "jrockit.";
    static final String NS_ORA = "oracle.";
    static final String NS_JAVA = "java.";
    static final String NS_SUN = "sun.";
    static final String NS_COM_SUN = "com.sun.";
    private static final String[] namespaces = new String[]{"jrockit.", "oracle.", "java.", "sun.", "com.sun."};
    protected final JVMManagement vmm;
    protected final JVM jvm;
    private final ObjectName name;
    private static Permission monitorPermission = new ManagementPermission("monitor");
    private static Permission controlPermission = new ManagementPermission("control");

    public BeanBase(JVMManagement mgmt) {
        this.vmm = mgmt;
        this.jvm = mgmt.getJVM();
        this.name = BeanBase.makeName(this.getClass());
    }

    private static ObjectName makeName(Class<? extends BeanBase> c) {
        try {
            Object o = c.getField("MBEAN_NAME").get(null);
            return new ObjectName((String)o);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public ObjectName getName() {
        return this.name;
    }

    public Counter getCounter(String name) {
        return this.vmm.getCounter(name);
    }

    public Counter getAnyCounter(String extension) {
        for (String s : namespaces) {
            Counter c = this.getCounter(s + extension);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    protected final void rethrowUnwrapped(RuntimeException e) throws Exception {
        if (e.getClass().equals(RuntimeException.class) && e.getCause() instanceof Exception) {
            throw (Exception)e.getCause();
        }
        throw e;
    }

    static void checkAccess(Permission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    static void checkMonitorAccess() throws SecurityException {
        BeanBase.checkAccess(monitorPermission);
    }

    static void checkControlAccess() throws SecurityException {
        BeanBase.checkAccess(controlPermission);
    }
}

