/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.log;

import java.io.PrintWriter;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;

public class PureJavaLogger
extends Logger {
    private MsgLevel level = MsgLevel.DEBUG;
    private PrintWriter out = new PrintWriter(System.out);

    public PureJavaLogger(String name) {
        super(name);
        String s = System.getProperty(name + ".logLevel", MsgLevel.WARN.name());
        this.level = MsgLevel.valueOf(s);
    }

    public boolean isLevel(MsgLevel l) {
        return l.shouldLog(this.level);
    }

    protected void output(MsgLevel l, String str) {
        this.out.print('[');
        this.out.print(this.name);
        this.out.print(']');
        this.out.print('[');
        this.out.print(l.name());
        this.out.print("] ");
        this.out.println(str);
        this.out.flush();
    }

    protected void output(MsgLevel l, String fmt, Object[] args) {
        this.out.print('[');
        this.out.print(this.name);
        this.out.print(']');
        this.out.print('[');
        this.out.print(l.name());
        this.out.print("] ");
        this.out.format(fmt, args);
        this.out.println();
        this.out.flush();
    }
}

