/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.log;

import java.util.Formatter;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;
import oracle.jrockit.log.NativeLogModule;

class NativeLogger
extends Logger {
    private final NativeLogModule module;
    private static final ThreadLocal<Formatter> formatterLocal = NativeLogModule.canDoNativeLogging() ? new ThreadLocal<Formatter>(){

        @Override
        protected Formatter initialValue() {
            return new Formatter();
        }
    } : null;

    static native void initIDs();

    public NativeLogger(NativeLogModule module) {
        super(module.getName());
        this.module = module;
    }

    public boolean isLevel(MsgLevel l) {
        return l.shouldLog(this.module.msgLevel());
    }

    protected void output(MsgLevel l, String str) {
        NativeLogModule.output(this.module.handle(), l.level(), str);
    }

    protected void output(MsgLevel l, String fmt, Object[] args) {
        Formatter f = formatterLocal.get();
        f.format(fmt, args);
        f.flush();
        this.output(l, f.toString());
        ((StringBuilder)f.out()).setLength(0);
    }
}

