/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.log;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import oracle.jrockit.log.MsgLevel;
import oracle.jrockit.log.SanityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLogModule {
    private final long handle;
    private final String[] names;
    private final ByteBuffer msgLevel;
    private final ByteBuffer sanityLevel;
    private final int defaultMsgLevel;
    private final int defaultSanityLevel;
    private static ArrayList<NativeLogModule> modules;
    private static HashMap<String, NativeLogModule> moduleMap;
    private static final boolean canDoNativeLogging;

    public NativeLogModule(long handle, String[] names, ByteBuffer msgLevel, ByteBuffer sanityLevel, int defaultMsgLevel, int defaultSanityLevel) {
        this.handle = handle;
        this.names = names;
        this.msgLevel = msgLevel.order(ByteOrder.nativeOrder());
        this.sanityLevel = sanityLevel.order(ByteOrder.nativeOrder());
        this.defaultMsgLevel = defaultMsgLevel;
        this.defaultSanityLevel = defaultSanityLevel;
    }

    long handle() {
        return this.handle;
    }

    int msgLevel() {
        return this.msgLevel.getInt(0);
    }

    int sanityLevel() {
        return this.sanityLevel.getInt(0);
    }

    int defaultMsgLevel() {
        return this.defaultMsgLevel;
    }

    int defaultSanityLevel() {
        return this.defaultSanityLevel;
    }

    public MsgLevel getMessageLevel() {
        return MsgLevel.values()[this.msgLevel()];
    }

    public SanityLevel getSanityLevel() {
        return SanityLevel.values()[this.sanityLevel()];
    }

    public MsgLevel getDefaultMessageLevel() {
        return MsgLevel.values()[this.defaultMsgLevel()];
    }

    public SanityLevel getDefaultSanityLevel() {
        return SanityLevel.values()[this.defaultSanityLevel()];
    }

    public boolean isVerbose() {
        return this.msgLevel() > this.defaultMsgLevel();
    }

    public void setVerbose(boolean on) {
        MsgLevel d = this.getDefaultMessageLevel();
        try {
            MsgLevel l = on ? MsgLevel.values()[d.ordinal() + 1] : MsgLevel.values()[d.ordinal() - 1];
            this.setMessageLevel(l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setMessageLevel(MsgLevel l) {
        this.msgLevel.putInt(0, l.level());
    }

    public void setMessageLevel(String level) {
        this.setMessageLevel(MsgLevel.valueOf(level.toUpperCase()));
    }

    public void setSanityLevel(SanityLevel l) {
        this.sanityLevel.putInt(0, l.level());
    }

    public void setSanityLevel(String level) {
        this.setSanityLevel(SanityLevel.valueOf(level.toUpperCase()));
    }

    public String getName() {
        return this.names[0];
    }

    public Collection<String> getAliases() {
        return Arrays.asList(this.names);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof NativeLogModule) {
            NativeLogModule other = (NativeLogModule)obj;
            return other.handle == this.handle;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.names[0]);
        if (this.names.length > 0) {
            buf.append('(');
            for (int i = 1; i < this.names.length; ++i) {
                buf.append(this.names[i]).append(',');
            }
            buf.setLength(buf.length() - 1);
            buf.append(')');
        }
        buf.append("=[").append((Object)this.getMessageLevel()).append(',').append((Object)this.getSanityLevel()).append(']');
        return buf.toString();
    }

    public static Collection<String> getModuleNames() {
        return Arrays.asList(NativeLogModule.getModuleNames0());
    }

    private static native String[] getModuleNames0();

    static boolean canDoNativeLogging() {
        return canDoNativeLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeLogModule getModule(String name) throws IllegalArgumentException {
        if (!canDoNativeLogging) {
            return null;
        }
        Class<NativeLogModule> clazz = NativeLogModule.class;
        synchronized (NativeLogModule.class) {
            NativeLogModule m = null;
            if (moduleMap != null && (m = moduleMap.get(name)) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return m;
            }
            m = NativeLogModule.getModule0(name);
            if (moduleMap == null) {
                moduleMap = new HashMap();
            }
            for (String s : m.names) {
                moduleMap.put(s, m);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<NativeLogModule> getAllModules() {
        Class<NativeLogModule> clazz = NativeLogModule.class;
        synchronized (NativeLogModule.class) {
            if (modules == null) {
                String[] names = NativeLogModule.getModuleNames0();
                modules = new ArrayList(names.length);
                for (String s : names) {
                    NativeLogModule m = NativeLogModule.getModule(s);
                    modules.add(m);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Collections.unmodifiableCollection(modules);
        }
    }

    private static native NativeLogModule getModule0(String var0);

    private static native void initIDs();

    static native void output(long var0, int var2, String var3);

    static {
        boolean ok = true;
        try {
            System.loadLibrary("util");
            NativeLogModule.initIDs();
        }
        catch (Error e) {
            ok = false;
        }
        canDoNativeLogging = ok;
    }
}

