/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.log;

import oracle.jrockit.log.MsgLevel;
import oracle.jrockit.log.NativeLogModule;
import oracle.jrockit.log.NativeLogger;
import oracle.jrockit.log.PureJavaLogger;

public abstract class Logger {
    protected final String name;

    public abstract boolean isLevel(MsgLevel var1);

    protected abstract void output(MsgLevel var1, String var2);

    private void output(MsgLevel l, Throwable t) {
        String msg = t.getClass().getName() + ":" + t.getMessage();
        this.output(l, msg);
        StackTraceElement[] trace = t.getStackTrace();
        this.output(l, trace);
        if (t.getCause() != null) {
            this.output(l, "Caused by: ", t.getCause());
        }
    }

    private void output(MsgLevel l, StackTraceElement[] trace) {
        for (StackTraceElement e : trace) {
            this.output(l, "   " + e.toString());
        }
    }

    protected void output(MsgLevel l, String str, Throwable t) {
        this.output(l, str);
        this.output(l, t);
    }

    protected void output(MsgLevel l, String str, StackTraceElement[] trace) {
        this.output(l, str);
        this.output(l, trace);
    }

    protected abstract void output(MsgLevel var1, String var2, Object[] var3);

    protected void output(MsgLevel l, Throwable t, String fmt, Object[] args) {
        this.output(l, fmt, args);
        this.output(l, t);
    }

    protected void output(MsgLevel l, StackTraceElement[] trace, String fmt, Object[] args) {
        this.output(l, fmt, args);
        this.output(l, trace);
    }

    Logger(String name) {
        this.name = name;
    }

    public static Logger loggerFor(String name) {
        if (NativeLogModule.canDoNativeLogging()) {
            try {
                return new NativeLogger(NativeLogModule.getModule(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new PureJavaLogger(name);
    }

    public final boolean isDebug() {
        return this.isLevel(MsgLevel.DEBUG);
    }

    public final boolean isInfo() {
        return this.isLevel(MsgLevel.INFO);
    }

    public final boolean isWarn() {
        return this.isLevel(MsgLevel.WARN);
    }

    public final boolean isTrace() {
        return this.isLevel(MsgLevel.TRACE);
    }

    public final boolean isQuiet() {
        return this.isLevel(MsgLevel.QUIET);
    }

    public final boolean isError() {
        return this.isLevel(MsgLevel.ERROR);
    }

    public final void info(String msg) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, msg);
    }

    public final void info(String msg, Throwable t) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, msg, t);
    }

    public final void info(String msg, StackTraceElement[] trace) {
        if (!this.isInfo()) {
            return;
        }
        this.output(MsgLevel.INFO, msg, trace);
    }

    public final void debug(String msg) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, msg);
    }

    public final void debug(String msg, Throwable t) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, msg, t);
    }

    public final void debug(String msg, StackTraceElement[] trace) {
        if (!this.isDebug()) {
            return;
        }
        this.output(MsgLevel.DEBUG, msg, trace);
    }

    public final void warn(String msg) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, msg);
    }

    public final void warn(String msg, Throwable t) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, msg, t);
    }

    public final void warn(String msg, StackTraceElement[] trace) {
        if (!this.isWarn()) {
            return;
        }
        this.output(MsgLevel.WARN, msg, trace);
    }

    public final void error(String msg) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, msg);
    }

    public final void error(String msg, Throwable t) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, msg, t);
    }

    public final void error(String msg, StackTraceElement[] trace) {
        if (!this.isError()) {
            return;
        }
        this.output(MsgLevel.ERROR, msg, trace);
    }

    public final void trace(String msg) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, msg);
    }

    public final void trace(String msg, Throwable t) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, msg, t);
    }

    public final void trace(String msg, StackTraceElement[] trace) {
        if (!this.isTrace()) {
            return;
        }
        this.output(MsgLevel.TRACE, msg, trace);
    }

    public final void forceLog(MsgLevel l, String fmt, Object ... args) {
        if (args.length == 0) {
            this.output(l, fmt);
        } else {
            this.output(l, fmt, args);
        }
    }

    public final void forceLog(MsgLevel l, Throwable t, String fmt, Object ... args) {
        if (args.length == 0) {
            this.output(l, fmt, t);
        } else {
            this.output(l, t, fmt, args);
        }
    }

    public final void forceLog(MsgLevel l, StackTraceElement[] trace, String fmt, Object ... args) {
        if (args.length == 0) {
            this.output(l, fmt, trace);
        } else {
            this.output(l, trace, fmt, args);
        }
    }

    public final void log(MsgLevel l, String fmt, Object ... args) {
        if (!this.isLevel(l)) {
            return;
        }
        this.forceLog(l, fmt, args);
    }

    public final void log(MsgLevel l, Throwable t, String fmt, Object ... args) {
        if (!this.isLevel(l)) {
            return;
        }
        this.forceLog(l, t, fmt, args);
    }

    public final void log(MsgLevel l, StackTraceElement[] trace, String fmt, Object ... args) {
        if (!this.isLevel(l)) {
            return;
        }
        this.forceLog(l, trace, fmt, args);
    }
}

