/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import oracle.jrockit.json.JSONArray;
import oracle.jrockit.json.JSONElement;
import oracle.jrockit.json.JSONObject;
import oracle.jrockit.json.JSONPrimitive;

class JSONTokener {
    private int line;
    private int columnStart;
    private int index;
    private Reader reader;
    private char lastChar;
    private boolean useLastChar;

    public JSONTokener(Reader reader) {
        this.reader = reader;
        this.useLastChar = false;
        this.index = 0;
    }

    public JSONTokener(String s) {
        this(new StringReader(s));
    }

    public void back() {
        if (this.useLastChar || this.index <= 0) {
            throw new IllegalStateException("Stepping back two steps not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public char next() throws IOException {
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        int c = this.reader.read();
        if (c <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        if (c == 10) {
            ++this.line;
            this.columnStart = this.index;
        }
        this.lastChar = (char)c;
        return this.lastChar;
    }

    private String next(int n) throws IOException, ParseException {
        int len;
        char[] buffer = new char[n];
        int pos = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            buffer[0] = this.lastChar;
            pos = 1;
        }
        while (pos < n && (len = this.reader.read(buffer, pos, n - pos)) != -1) {
            pos += len;
        }
        this.index += pos;
        if (pos < n) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = buffer[n - 1];
        return new String(buffer);
    }

    private void skipTo(int c) throws IOException {
        char n;
        while ((n = this.next()) != c) {
        }
    }

    public char nextClean() throws IOException {
        char c;
        while (true) {
            if ((c = this.next()) == '/') {
                char n = this.next();
                if (n == '/') {
                    this.skipTo(10);
                    continue;
                }
                if (n == '*') {
                    do {
                        this.skipTo(42);
                    } while ((n = this.next()) != '/');
                    continue;
                }
                this.back();
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char quote) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    JSONElement nextValue() throws IOException, ParseException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return new JSONPrimitive(this.nextString(c));
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '(': 
            case '[': {
                this.back();
                return new JSONArray(this);
            }
        }
        StringBuilder sb = new StringBuilder();
        while (c > ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String s = sb.toString().trim();
        if (s.equals("")) {
            throw this.syntaxError("Missing value");
        }
        return new JSONPrimitive(JSONTokener.stringToValue(s));
    }

    private static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return null;
        }
        char b = s.charAt(0);
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0') {
                if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                    try {
                        return new Integer(Integer.parseInt(s.substring(2), 16));
                    }
                    catch (Exception e) {
                    }
                } else {
                    try {
                        return new Integer(Integer.parseInt(s, 8));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            try {
                if (s.indexOf(46) > -1 || s.indexOf(101) > -1 || s.indexOf(69) > -1) {
                    return Double.valueOf(s);
                }
                Long myLong = new Long(s);
                if (myLong == (long)myLong.intValue()) {
                    return new Integer(myLong.intValue());
                }
                return myLong;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    public ParseException syntaxError(String message) {
        StringBuilder buf = new StringBuilder();
        if (!this.useLastChar && this.lastChar != '\u0000' && this.index > 0) {
            this.back();
        }
        buf.append(message).append(", line=").append(this.line).append(", column=").append(this.index - this.columnStart);
        buf.append(" : ");
        for (int i = 0; i < 100; ++i) {
            try {
                char c = this.next();
                if (c == '\u0000') break;
                buf.append(c);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return new ParseException(buf.toString(), this.index);
    }
}

