/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import java.util.Collection;
import java.util.Iterator;
import oracle.jrockit.json.JSONElement;
import oracle.jrockit.json.JSONMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONPrimitive
extends JSONElement {
    final Object value;

    JSONPrimitive(Object t) {
        this.value = t;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public JSONElement value(int index) {
        throw new RuntimeException("not an object or array");
    }

    @Override
    public JSONMember member(int index) {
        throw new RuntimeException("not an object");
    }

    @Override
    public JSONMember member(String name) {
        throw new RuntimeException("not an object");
    }

    @Override
    public Iterator<JSONMember> iterator() {
        throw new RuntimeException("not an object");
    }

    @Override
    public Collection<JSONElement> values() {
        throw new RuntimeException("not an array");
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    String toString(int indent) {
        if (this.value instanceof String) {
            return "\"" + this.value + "\"";
        }
        return this.stringValue();
    }

    @Override
    public boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.booleanValue();
    }

    @Override
    public double doubleValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.doubleValue();
    }

    @Override
    public long longValue() {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.longValue();
    }
}

