/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.jrockit.json.JSONElement;
import oracle.jrockit.json.JSONMember;
import oracle.jrockit.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONObject
extends JSONElement {
    private final ArrayList<JSONMember> values = new ArrayList();

    JSONObject(JSONTokener x) throws ParseException, IOException {
        if (x.nextClean() != '{') {
            throw x.syntaxError("JSON object must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("JSON object must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().stringValue();
            c = x.nextClean();
            if (c != '=' && c != ':') {
                throw x.syntaxError("Expected ':' after a key");
            }
            this.values.add(new JSONMember(key, x.nextValue()));
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected ',' or '}'");
    }

    void add(JSONMember m) {
        this.values.add(m);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public JSONElement value(int index) {
        return this.values.get(index).getValue();
    }

    @Override
    public JSONMember member(int index) {
        return this.values.get(index);
    }

    @Override
    public JSONMember member(String name) {
        for (JSONMember m : this.values) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Override
    public Iterator<JSONMember> iterator() {
        return this.values.iterator();
    }

    @Override
    public Collection<JSONElement> values() {
        throw new RuntimeException("not an array");
    }

    @Override
    public Object value() {
        return this;
    }

    @Override
    String toString(int indent) {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        ++indent;
        for (JSONMember m : this.values) {
            JSONObject.indent(buf, indent);
            buf.append(m.toString(indent)).append(",\n");
        }
        JSONObject.indent(buf, indent - 1);
        buf.append("}");
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }
}

