/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import oracle.jrockit.json.JSONElement;

public class JSONMember {
    private final String name;
    private final JSONElement value;

    JSONMember(String name, JSONElement v) {
        this.name = name;
        this.value = v;
    }

    public final String getName() {
        return this.name;
    }

    public JSONElement getValue() {
        return this.value;
    }

    String toString(int indent) {
        return this.name + " : " + this.value.toString(indent);
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(JSONMember m) {
        if (m == null) {
            return false;
        }
        if (!this.name.equals(m.getName())) {
            return false;
        }
        JSONElement v = m.getValue();
        if (this.value == v) {
            return true;
        }
        if (this.value == null || v == null) {
            return false;
        }
        return this.value.equals(v);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JSONMember) {
            return this.equals((JSONMember)obj);
        }
        return false;
    }
}

