/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Collection;
import oracle.jrockit.json.JSONArray;
import oracle.jrockit.json.JSONMember;
import oracle.jrockit.json.JSONObject;
import oracle.jrockit.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONElement
implements Iterable<JSONMember> {
    public abstract boolean isArray();

    public abstract boolean isObject();

    public abstract boolean isValue();

    public abstract int size();

    public abstract JSONElement value(int var1);

    public abstract JSONMember member(int var1);

    public abstract JSONMember member(String var1);

    public abstract Object value();

    private void checkValue() {
        if (!this.isValue()) {
            throw new RuntimeException("not value");
        }
    }

    public boolean booleanValue() {
        this.checkValue();
        String s = String.valueOf(this.value());
        if ("true".equalsIgnoreCase(s) || "1".equals(s)) {
            return true;
        }
        if ("false".equalsIgnoreCase(s) || "0".equals(s)) {
            return false;
        }
        throw new IllegalArgumentException(s);
    }

    public long longValue() {
        this.checkValue();
        String s = String.valueOf(this.value());
        return Long.parseLong(s);
    }

    public double doubleValue() {
        this.checkValue();
        String s = String.valueOf(this.value());
        return Double.parseDouble(s);
    }

    public String stringValue() {
        this.checkValue();
        return String.valueOf(this.value());
    }

    public abstract Collection<JSONElement> values();

    public static JSONElement parse(String contents) throws ParseException, IOException {
        return JSONElement.parse(new StringReader(contents));
    }

    public static JSONElement parse(InputStream in) throws ParseException, IOException {
        return JSONElement.parse(new InputStreamReader(in));
    }

    public static JSONElement parse(Reader in) throws ParseException, IOException {
        JSONTokener t = new JSONTokener(in);
        char c = t.nextClean();
        t.back();
        if (c == '[') {
            return new JSONArray(t);
        }
        return new JSONObject(t);
    }

    static void indent(StringBuilder buf, int indent) {
        while (indent-- > 0) {
            buf.append('\t');
        }
    }

    abstract String toString(int var1);

    public String toString() {
        return this.toString(0);
    }

    public boolean equals(JSONElement e) {
        int n = this.size();
        if (n != e.size()) {
            return false;
        }
        if (this.isArray() && e.isArray()) {
            for (int i = 0; i < n; ++i) {
                JSONElement e2;
                JSONElement e1 = this.value(i);
                if (e1.equals(e2 = e.value(i))) continue;
                return false;
            }
            return true;
        }
        if (this.isObject() && e.isObject()) {
            for (int i = 0; i < n; ++i) {
                JSONMember m2;
                JSONMember m1 = this.member(i);
                if (m1.equals(m2 = e.member(m1.getName()))) continue;
                return false;
            }
            return true;
        }
        if (this.isValue() && e.isValue()) {
            Object o1 = this.value();
            Object o2 = e.value();
            if (o1 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JSONElement) {
            return this.equals((JSONElement)obj);
        }
        return false;
    }
}

