/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.json;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.jrockit.json.JSONElement;
import oracle.jrockit.json.JSONMember;
import oracle.jrockit.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONArray
extends JSONElement {
    private final ArrayList<JSONElement> values = new ArrayList();

    JSONArray(JSONTokener x) throws ParseException, IOException {
        char c = x.nextClean();
        if (c != '[') {
            throw x.syntaxError("JSON array must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.values.add(null);
            } else {
                x.back();
                this.values.add(x.nextValue());
            }
            c = x.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected ',' or ']'");
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public JSONElement value(int index) {
        return this.values.get(index);
    }

    @Override
    public JSONMember member(int index) {
        throw new RuntimeException("not an object");
    }

    @Override
    public JSONMember member(String name) {
        throw new RuntimeException("not an object");
    }

    @Override
    public Iterator<JSONMember> iterator() {
        throw new RuntimeException("not an object");
    }

    @Override
    public Collection<JSONElement> values() {
        return this.values;
    }

    @Override
    public Object value() {
        return this;
    }

    @Override
    String toString(int indent) {
        StringBuilder buf = new StringBuilder();
        buf.append("[\n");
        ++indent;
        for (JSONElement m : this.values) {
            JSONArray.indent(buf, indent);
            buf.append(m.toString(indent)).append(",\n");
        }
        JSONArray.indent(buf, indent - 1);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(0);
    }
}

