/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

public class ConCatRepository {
    private File repositoryDirectory;
    private File outFile;
    private boolean forceOverwrite = false;

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println(ConCatRepository.class.getSimpleName() + " JFR Repository directory [-o <outfile>]");
        System.out.println("optional -o: output filename");
        System.out.println("optional -f: force file overwrite");
    }

    public static void main(String[] args) throws Exception {
        ConCatRepository ct = new ConCatRepository();
        ct.loadFiles(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFiles(String[] args) throws IOException, FileNotFoundException {
        if (args.length == 0) {
            this.repositoryDirectory = new File(".");
        } else if (!this.parseArgs(args)) {
            return;
        }
        if (!this.repositoryDirectory.exists()) {
            ConCatRepository.usage();
            throw new FileNotFoundException("Could not find jfr repository " + this.repositoryDirectory);
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".jfr");
            }
        };
        Object[] flightRecordingParts = this.repositoryDirectory.list(filter);
        if (0 == flightRecordingParts.length) {
            ConCatRepository.usage();
            throw new FileNotFoundException("Could not find any incomplete flight recordings in the specified directory");
        }
        Arrays.sort(flightRecordingParts);
        if (null == this.outFile) {
            this.outFile = new File(((String)flightRecordingParts[0]).substring(0, ((String)flightRecordingParts[0]).indexOf(".")) + "-" + ((String)flightRecordingParts[flightRecordingParts.length - 1]).substring(0, ((String)flightRecordingParts[flightRecordingParts.length - 1]).indexOf(".")) + ".jfr");
        }
        if (this.outFile.exists() && !this.forceOverwrite) {
            throw new IOException("The specified file already exists " + this.outFile + "." + " Use -f to force override");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outFile), 4096);
        try {
            for (Object part : flightRecordingParts) {
                int len;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(this.repositoryDirectory + "/" + (String)part)), 4096);
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean parseArgs(String[] args) {
        int i = 0;
        if (!args[0].startsWith("-")) {
            this.repositoryDirectory = new File(args[0]);
            ++i;
        } else {
            this.repositoryDirectory = new File(".");
        }
        try {
            char flag;
            block6: while (i < args.length) {
                flag = args[i].charAt(1);
                switch (flag) {
                    case 'o': {
                        this.outFile = new File(args[i + 1]);
                        i += 2;
                        continue block6;
                    }
                    case 'f': {
                        this.forceOverwrite = true;
                        ++i;
                        continue block6;
                    }
                }
            }
            return true;
            System.err.println("Unknown flag: " + flag);
            ConCatRepository.usage();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("To few arguments:");
            ConCatRepository.usage();
        }
        return true;
    }
}

