/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.jrockit.jfr.parser.ContentTypeDescriptor;
import oracle.jrockit.jfr.parser.EventData;
import oracle.jrockit.jfr.parser.FLREventInfo;
import oracle.jrockit.jfr.parser.FLRProducer;
import oracle.jrockit.jfr.parser.ValueData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProducerData
implements FLRProducer {
    final int id;
    final String namespace;
    final URI uri;
    final String name;
    final String desc;
    final List<EventData> events;
    final HashMap<Integer, ContentTypeDescriptor> contentTypes;
    final List<ValueData[]> structs;

    public ProducerData(int id, String name, String desc, URI uri, String namespace, List<EventData> events, HashMap<Integer, ContentTypeDescriptor> contentTypes, List<ValueData[]> structs) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.uri = uri;
        this.namespace = namespace;
        this.events = events;
        this.contentTypes = contentTypes;
        this.structs = structs;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public List<FLREventInfo> getEventInfos() {
        ArrayList<FLREventInfo> l = new ArrayList<FLREventInfo>(this.events.size());
        l.addAll(this.events);
        return l;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getURIString() {
        return this.uri.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name).append("[").append(this.id).append(',').append(this.desc).append(',').append(this.uri).append("]");
        return buf.toString();
    }
}

