/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.FLREvent;
import oracle.jrockit.jfr.parser.FLRInput;
import oracle.jrockit.jfr.parser.MappedFLRInput;
import oracle.jrockit.jfr.parser.ParseException;
import oracle.jrockit.jfr.parser.RandomAccessFileFLRInput;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements Iterable<ChunkParser> {
    private final FLRInput input;
    private long nextChunk;
    static final String JFR_URI = "http://www.oracle.com/jrockit/jfr/";
    static final String JFR_NS = "jfr";

    public Parser(String path) throws IOException {
        this(path, true);
    }

    public Parser(String path, boolean useMapped) throws IOException {
        this(new File(path));
    }

    public Parser(File file, boolean useMapping) throws IOException {
        RandomAccessFile r = new RandomAccessFile(file, "r");
        long size = r.length();
        FLRInput in = null;
        if (useMapping && size < 0x3200000L) {
            FileChannel ch = r.getChannel();
            try {
                MappedByteBuffer buf = ch.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                in = new MappedFLRInput(buf);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (in == null) {
            in = new RandomAccessFileFLRInput(r);
        }
        this.input = in;
    }

    public Parser(File file) throws IOException {
        this(file, true);
    }

    public ChunkParser next() throws IOException, ParseException {
        if (this.nextChunk >= this.input.size()) {
            return null;
        }
        this.input.position(this.nextChunk);
        ChunkParser p = new ChunkParser(this.input);
        this.nextChunk = p.getChunkEnd();
        return p;
    }

    public void writeXML(ContentHandler h) throws SAXException, IOException, ParseException {
        ChunkParser c;
        h.startElement(JFR_URI, "flightrecording", "jfr:flightrecording", new AttributesImpl());
        while ((c = this.next()) != null) {
            c.writeXML(h);
        }
        h.endElement(JFR_URI, "flightrecording", "jfr:flightrecording");
    }

    @Override
    public Iterator<ChunkParser> iterator() {
        return new Iterator<ChunkParser>(){
            private ChunkParser p;

            @Override
            public boolean hasNext() {
                try {
                    this.p = Parser.this.next();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this.p != null;
            }

            @Override
            public ChunkParser next() {
                return this.p;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void close() throws IOException {
        this.input.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i = 0;
        boolean xml = false;
        if (args[0].equals("-xml")) {
            xml = true;
            ++i;
        }
        Parser p = new Parser(args[i]);
        if (xml) {
            TransformerFactory f = TransformerFactory.newInstance();
            if (!f.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new SAXException("cannot construct output handler");
            }
            SAXTransformerFactory sf = (SAXTransformerFactory)f;
            sf.setAttribute("indent-number", "3");
            TransformerHandler th = sf.newTransformerHandler();
            th.getTransformer().setOutputProperty("method", "xml");
            th.getTransformer().setOutputProperty("indent", "yes");
            th.getTransformer().setOutputProperty("encoding", "iso-8859-1");
            PrintWriter w = new PrintWriter(System.out);
            th.setResult(new StreamResult(w));
            p.writeXML(th);
            w.flush();
            return;
        }
        try {
            ChunkParser c;
            while ((c = p.next()) != null) {
                FLREvent o;
                System.out.println("new chunk");
                while ((o = c.next()) != null) {
                    System.out.println(o);
                }
            }
        }
        finally {
            System.out.flush();
        }
    }
}

