/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import java.net.URI;
import oracle.jrockit.jfr.parser.AbstractStructProxy;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.EventData;
import oracle.jrockit.jfr.parser.FLREvent;
import oracle.jrockit.jfr.parser.FLRStruct;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.ValueData;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class EventProxy
extends AbstractStructProxy
implements FLREvent {
    final int id;
    final long timestamp;

    public EventProxy(ChunkParser chunkParser, int id, long timestamp, Object[] values) {
        super(chunkParser, values);
        this.id = id;
        this.timestamp = timestamp;
    }

    public FLRStruct getStackTrace() {
        EventData d = this.chunkParser.eventTypes.get(this.id);
        if (!d.hasStackTrace()) {
            return null;
        }
        int index = 0;
        if (d.hasStartTime()) {
            ++index;
        }
        if (d.hasThread()) {
            ++index;
        }
        return (FLRStruct)this.getResolvedValue(index);
    }

    public long getStartTime() {
        EventData d = this.chunkParser.eventTypes.get(this.id);
        if (!d.hasStartTime()) {
            return 0L;
        }
        return (Long)this.getResolvedValue(0);
    }

    public int getThreadId() {
        EventData d = this.chunkParser.eventTypes.get(this.id);
        if (!d.hasThread()) {
            return 0;
        }
        int index = 0;
        if (d.hasStartTime()) {
            ++index;
        }
        return (Integer)this.getValue(index);
    }

    public FLRStruct getThread() {
        EventData d = this.chunkParser.eventTypes.get(this.id);
        if (!d.hasThread()) {
            return null;
        }
        int index = 0;
        if (d.hasStartTime()) {
            ++index;
        }
        return (FLRStruct)this.getResolvedValue(index);
    }

    protected long timestamp() {
        return this.timestamp;
    }

    protected ValueData[] valueData() {
        return (ValueData[])this.chunkParser.eventTypes.get(this.id).getValues();
    }

    protected ProducerData producer() {
        return this.chunkParser.producers.get(this.chunkParser.eventTypes.get((Object)Integer.valueOf((int)this.id)).producer);
    }

    public int getId() {
        return this.id;
    }

    public long getProducerId() {
        return this.chunkParser.eventTypes.get((Object)Integer.valueOf((int)this.id)).producer;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.chunkParser.eventTypes.get(this.id).getDescription();
    }

    public String getName() {
        return this.chunkParser.eventTypes.get(this.id).getName();
    }

    public String getPath() {
        return this.chunkParser.eventTypes.get(this.id).getPath();
    }

    public URI getURI() {
        return this.chunkParser.eventTypes.get(this.id).getURI();
    }

    protected EventData eventData() {
        return this.chunkParser.eventTypes.get(this.id);
    }

    void xmlSnippet(ContentHandler h) throws SAXException {
        EventData d = this.eventData();
        AttributesImpl a = new AttributesImpl();
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "timestamp", "jfr:timestamp", "", String.valueOf(this.timestamp));
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "id", "jfr:id", "", String.valueOf(this.getId()));
        String uri = this.producerURI();
        h.startElement(uri, d.xmlname, d.qname, a);
        super.xmlSnippet(h);
        h.endElement(uri, d.xmlname, d.qname);
    }

    void print(StringBuilder buf, int indent) {
        buf.append(this.getName() + "@" + this.timestamp + " = ");
        super.print(buf, indent);
    }

    public boolean hasStackTrace() {
        return this.chunkParser.eventTypes.get(this.id).hasStackTrace();
    }

    public boolean hasStartTime() {
        return this.chunkParser.eventTypes.get(this.id).hasStartTime();
    }

    public boolean hasThread() {
        return this.chunkParser.eventTypes.get(this.id).hasThread();
    }
}

