/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.FLREventInfo;
import oracle.jrockit.jfr.parser.FLRValueInfo;
import oracle.jrockit.jfr.parser.ValueData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventData
extends JavaEventDescriptor
implements FLREventInfo {
    final int producer;
    final String xmlname;
    final String qname;

    public EventData(int producer, URI uri, String namespace, String name, String description, String path, boolean hasStartTime, boolean hasThread, boolean stacktrace, boolean timed, boolean requestable, int id, ValueData ... values) throws InvalidValueException, InvalidEventDefinitionException {
        super(id, name, description, path, uri.resolve(path == null ? "" : path), hasStartTime, hasThread, stacktrace, timed, requestable, (ValueDescriptor[])values);
        this.producer = producer;
        this.xmlname = ChunkParser.xmlName(path, name);
        this.qname = namespace + ":" + this.xmlname;
    }

    @Override
    public List<? extends FLRValueInfo> getValueInfos() {
        ValueData[] descs = (ValueData[])this.getValues();
        return Arrays.asList(descs);
    }
}

