/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.DataType;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Transition;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jrockit.jfr.events.ContentTypeImpl;
import oracle.jrockit.jfr.events.DataStructureDescriptor;
import oracle.jrockit.jfr.parser.BufferLostEvent;
import oracle.jrockit.jfr.parser.ContentTypeDescriptor;
import oracle.jrockit.jfr.parser.ContentTypeResolver;
import oracle.jrockit.jfr.parser.EventData;
import oracle.jrockit.jfr.parser.EventProxy;
import oracle.jrockit.jfr.parser.FLREvent;
import oracle.jrockit.jfr.parser.FLRInput;
import oracle.jrockit.jfr.parser.FLRProducer;
import oracle.jrockit.jfr.parser.ParseException;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.ValueData;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkParser
implements Iterable<FLREvent> {
    public static final String EVENT_THREAD_ID = "_thread";
    public static final String START_TIME_ID = "_start";
    public static final String STACKTRACE_ID = "_stacktrace";
    private final FLRInput input;
    private final long chunkStart;
    private final long chunkEnd;
    private long start;
    private long end;
    private long startTicks;
    private long ticksPerSecond;
    private TimeZone timezone;
    private Locale locale;
    private byte[] buffer;
    private char[] cbuffer;
    private int major;
    private int minor;
    private int version;
    final HashMap<Integer, ValueData[]> structs = new HashMap();
    final HashMap<Integer, EventData> eventTypes = new HashMap();
    final HashMap<Integer, ContentTypeResolver> resolvers = new HashMap();
    final HashMap<Integer, ContentTypeDescriptor> contentDescs = new HashMap();
    final HashMap<Integer, ProducerData> producers = new HashMap();
    static Attributes empty = new AttributesImpl();

    ChunkParser(FLRInput input) throws IOException, ParseException {
        this.input = input;
        this.chunkStart = input.position();
        this.chunkEnd = this.begin();
    }

    long getChunkStart() {
        return this.chunkStart;
    }

    long getChunkEnd() {
        return this.chunkEnd;
    }

    public List<? extends FLRProducer> getProducers() {
        ArrayList<ProducerData> l = new ArrayList<ProducerData>();
        l.addAll(this.producers.values());
        return l;
    }

    public long getStartTimestampMillis() {
        return this.start;
    }

    public long getEndTimestampMillis() {
        return this.end;
    }

    public long getStartTimeStampTicks() {
        return this.startTicks;
    }

    public long ticksToNanos(long ticks) {
        return (long)((double)ticks / ((double)this.ticksPerSecond / 1.0E9));
    }

    public long ticksToMicros(long ticks) {
        return (long)((double)ticks / ((double)this.ticksPerSecond / 1000000.0));
    }

    public long ticksToMillis(long ticks) {
        return (long)((double)ticks / ((double)this.ticksPerSecond / 1000.0));
    }

    public long ticksToSeconds(long ticks) {
        return (long)((double)ticks / (double)this.ticksPerSecond);
    }

    public long getTickFrequency() {
        return this.ticksPerSecond;
    }

    private void move(long chunkpos) throws IOException {
        this.input.position(chunkpos + this.chunkStart);
    }

    private long absolute(long relativepos) {
        return relativepos + this.chunkStart;
    }

    private long begin() throws IOException, ParseException {
        this.move(0L);
        byte[] bytes = new byte[4];
        this.input.get(bytes);
        if (bytes[0] != 70 || bytes[1] != 76 || bytes[2] != 82 || bytes[3] != 0) {
            throw new ParseException("Bad file header : " + Arrays.toString(bytes));
        }
        this.major = this.input.getShort();
        this.minor = this.input.getShort();
        this.version = this.major << 16 | this.minor;
        long desc = this.input.getLong();
        this.move(desc);
        long cend = this.readDescriptors();
        this.start = this.input.getLong();
        this.end = this.input.getLong();
        this.startTicks = this.input.getLong();
        this.ticksPerSecond = this.input.getLong();
        long prevCP = this.input.getLong();
        String loc = this.readUTF();
        String[] lparts = loc.split("_");
        switch (lparts.length) {
            case 1: {
                this.locale = new Locale(loc);
                break;
            }
            case 2: {
                this.locale = new Locale(lparts[0], lparts[1]);
                break;
            }
            case 3: {
                this.locale = new Locale(lparts[0], lparts[1], lparts[2]);
                break;
            }
            default: {
                throw new ParseException("Bad locale " + loc);
            }
        }
        int gmtoffset = this.input.getInt();
        try {
            this.timezone = TimeZone.getTimeZone(TimeZone.getAvailableIDs(gmtoffset)[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Bad TimeZone " + gmtoffset);
        }
        while (prevCP != 0L) {
            prevCP = this.parseCP(prevCP);
        }
        this.move(16L);
        return cend;
    }

    EventProxy nextEvent() throws ParseException, IOException {
        int size = this.input.getInt();
        int id = this.input.getInt();
        long timestamp = this.input.getLong();
        while (id == 1) {
            long pos = this.input.position();
            this.input.position(pos + (long)size - 4L - 4L - 8L);
            size = this.input.getInt();
            id = this.input.getInt();
            timestamp = this.input.getLong();
        }
        if (id == 2) {
            Object[] values = this.readStruct(BufferLostEvent.struct);
            return new BufferLostEvent(this, timestamp, values);
        }
        if (id == 0) {
            return null;
        }
        EventData d = this.eventTypes.get(id);
        if (d == null) {
            throw new ParseException("Bad event id " + id);
        }
        Object[] values = this.readStruct((ValueData[])d.getValues());
        return new EventProxy(this, id, timestamp, values);
    }

    public FLREvent next() throws ParseException, IOException {
        return this.nextEvent();
    }

    final Object[] resolve(int contentTypeID, Number value, long timestamp) {
        ContentTypeResolver r = this.resolvers.get(contentTypeID);
        if (r == null) {
            if (this.contentDescs.get(contentTypeID) == null) {
                throw new IllegalArgumentException("bad content type: contentTypeID=" + contentTypeID + " value=" + value + " timestamp=" + timestamp);
            }
            return null;
        }
        while (r != null && r.timestamp < timestamp) {
            r = r.next;
        }
        while (r != null) {
            Object[] content = r.map.get(value);
            if (content != null) {
                return content;
            }
            r = r.next;
        }
        return null;
    }

    @Override
    public Iterator<FLREvent> iterator() {
        return new Iterator<FLREvent>(){
            private FLREvent e;

            @Override
            public boolean hasNext() {
                try {
                    this.e = ChunkParser.this.next();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return this.e != null;
            }

            @Override
            public FLREvent next() {
                return this.e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void writeXML(ContentHandler h) throws SAXException, IOException, ParseException {
        EventProxy e;
        AttributesImpl a = new AttributesImpl();
        SimpleDateFormat d = new SimpleDateFormat("yyyyMMdd-HHmmssSS");
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "startTime", "jfr:startTime", "", d.format(new Date(this.start)));
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "endTime", "jfr:endTime", "", d.format(new Date(this.end)));
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "startTicks", "jfr:startTicks", "", String.valueOf(this.startTicks));
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "ticksPerMillis", "jfr:ticksPerMillis", "", String.valueOf(this.ticksPerSecond));
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "timezone", "jfr:timezone", "", this.timezone.getID());
        a.addAttribute("http://www.oracle.com/jrockit/jfr/", "locale", "jfr:locale", "", this.locale.toString());
        for (ProducerData p : this.producers.values()) {
            h.startPrefixMapping(p.namespace, p.uri.toString());
        }
        h.startElement("http://www.oracle.com/jrockit/jfr/", "chunk", "jfr:chunk", a);
        for (ProducerData p : this.producers.values()) {
            AttributesImpl pa = new AttributesImpl();
            pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "id", "jfr:id", "", String.valueOf(p.id));
            pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "name", "jfr:name", "", p.name);
            pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "description", "jfr:description", "", p.desc);
            pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "uri", "jfr:uri", "", p.uri.toString());
            pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "namespace", "jfr:namespace", "", p.namespace);
            h.startElement("http://www.oracle.com/jrockit/jfr/", "producer", "jfr:producer", pa);
            for (EventData e2 : p.events) {
                pa.clear();
                pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "id", "jfr:id", "", String.valueOf(e2.getId()));
                pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "name", "jfr:name", "", e2.getName());
                pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "description", "jfr:description", "", e2.getDescription());
                pa.addAttribute("http://www.oracle.com/jrockit/jfr/", "path", "jfr:path", "", e2.getPath());
                h.startElement("http://www.oracle.com/jrockit/jfr/", "event", "jfr:event", pa);
                h.endElement("http://www.oracle.com/jrockit/jfr/", "event", "jfr:event");
            }
            h.endElement("http://www.oracle.com/jrockit/jfr/", "producer", "jfr:producer");
        }
        while ((e = this.nextEvent()) != null) {
            e.xmlSnippet(h);
        }
        h.endElement("http://www.oracle.com/jrockit/jfr/", "chunk", "jfr:chunk");
        for (ProducerData p : this.producers.values()) {
            h.endPrefixMapping(p.namespace);
        }
    }

    private long parseCP(long pos) throws IOException, ParseException {
        int pid;
        ProducerData p;
        this.move(pos);
        int size = this.input.getInt();
        long end = this.absolute(pos + (long)size);
        int id = this.input.getInt();
        long time = this.input.getLong();
        if (id != 1) {
            throw new ParseException("Illegal checkpoint event id " + id);
        }
        if (this.minor < 7 && this.major == 0 && (p = this.producers.get(pid = this.input.getInt())) == null) {
            throw new ParseException("Bad producer id " + pid);
        }
        long pcp = this.input.getLong();
        while (this.input.position() < end) {
            int cid = this.input.getInt();
            ContentTypeDescriptor cd = this.contentDescs.get(cid);
            if (cd == null) {
                throw new ParseException("Bad content type in constant pool : " + cid);
            }
            int n = this.input.getInt();
            if (n == 0) continue;
            HashMap<Number, Object[]> map = new HashMap<Number, Object[]>();
            ValueData[] struct = (ValueData[])cd.getValues();
            for (int i = 0; i < n; ++i) {
                Number key = (Number)this.readPrimitive(cd.contentType.getType());
                Object[] values = this.readStruct(struct);
                map.put(key, values);
            }
            int index = cd.contentType.getOrdinal();
            ContentTypeResolver r = new ContentTypeResolver(cd, map, time, this.resolvers.get(index));
            this.resolvers.put(index, r);
        }
        return pcp;
    }

    private Object[] readStruct(ValueData[] struct) throws IOException, ParseException {
        int n = struct.length;
        Object[] res = new Object[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.readValue(struct[i]);
        }
        return res;
    }

    private Object readValue(ValueData d) throws IOException, ParseException {
        DataType t = d.getDataType();
        switch (t) {
            case ARRAY: {
                int len = this.input.getInt();
                Object[] result = new Object[len];
                DataType at = DataType.values()[d.getInnerType()];
                for (int i = 0; i < len; ++i) {
                    result[i] = this.readPrimitive(at);
                }
                return result;
            }
            case STRUCT: {
                ProducerData p = this.producers.get(d.producer);
                ValueData[] struct = p.structs.get(d.getInnerType());
                return this.readStruct(struct);
            }
            case STRUCTARRAY: {
                int len = this.input.getInt();
                Object[] result = new Object[len];
                ProducerData p = this.producers.get(d.producer);
                ValueData[] struct = p.structs.get(d.getInnerType());
                for (int i = 0; i < len; ++i) {
                    result[i] = this.readStruct(struct);
                }
                return result;
            }
        }
        return this.readPrimitive(t);
    }

    private Object readPrimitive(DataType dataType) throws IOException, ParseException {
        switch (dataType) {
            case BOOLEAN: {
                return this.input.get() != 0;
            }
            case BYTE: 
            case U1: {
                return this.input.get();
            }
            case SHORT: 
            case U2: {
                return this.input.getShort();
            }
            case INTEGER: 
            case U4: {
                return this.input.getInt();
            }
            case LONG: 
            case U8: {
                return this.input.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.input.getFloat());
            }
            case DOUBLE: {
                return this.input.getDouble();
            }
            case UTF8: {
                return this.readUTF();
            }
            case STRING: {
                return this.readString();
            }
        }
        throw new ParseException("not implemented : " + (Object)((Object)dataType));
    }

    private long readDescriptors() throws IOException, ParseException {
        long pos = this.input.position();
        int size = this.input.getInt();
        int id = this.input.getInt();
        if (id != 0) {
            throw new ParseException("Bad descriptor section, id=" + id);
        }
        int n = this.input.getInt();
        while (n-- > 0) {
            this.readProducer();
        }
        return pos + (long)size;
    }

    private byte[] buffer(int len) {
        if (this.buffer == null || this.buffer.length < len) {
            this.buffer = new byte[len];
        }
        return this.buffer;
    }

    private char[] cbuffer(int len) {
        if (this.cbuffer == null || this.cbuffer.length < len) {
            this.cbuffer = new char[len];
        }
        return this.cbuffer;
    }

    private String readUTF() throws IOException {
        short len = this.input.getShort();
        byte[] buffer = this.buffer(len);
        this.input.get(buffer, 0, len);
        return new String(buffer, 0, (int)len, "UTF-8");
    }

    private String readString() throws IOException {
        int len = this.input.getInt();
        char[] buffer = this.cbuffer(len);
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)this.input.getShort();
        }
        return new String(buffer, 0, len);
    }

    private DataType getDataType(int index) throws ParseException {
        try {
            return DataType.values()[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Illegal data type : " + index);
        }
    }

    private void readProducer() throws IOException, ParseException {
        DataStructureDescriptor d;
        byte datatype;
        boolean isOldPID = this.major < 1 && this.minor < 8;
        int pid = this.input.getInt();
        if (!isOldPID && pid == 0) {
            throw new ParseException("Reserved producer id");
        }
        String pname = this.readUTF();
        String pdesc = this.readUTF();
        String tmp = this.readUTF();
        URI uri = null;
        try {
            uri = new URI(tmp);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e);
        }
        int jvmpid = isOldPID ? 0 : 1;
        String ns = pid == jvmpid ? "jvm" : "p" + pid;
        int m = this.input.getInt();
        ArrayList<String> relations = null;
        if (this.minor > 5 || this.major > 0) {
            relations = new ArrayList<String>(m);
            while (m-- > 0) {
                relations.add(this.readUTF());
            }
            m = this.input.getInt();
        }
        ArrayList<ValueData[]> structList = new ArrayList<ValueData[]>(m);
        while (m-- > 0) {
            int n = this.input.getInt();
            ValueData[] descs = new ValueData[n];
            for (int i = 0; i < n; ++i) {
                ContentTypeImpl ct;
                DataType dt;
                String id = this.readUTF();
                String name = this.readUTF();
                String desc = this.readUTF();
                byte ti = this.input.get();
                datatype = this.input.get();
                int contenttype = this.input.getInt();
                int arraytype = this.input.getInt();
                this.input.getInt();
                Transition tt = Transition.values()[ti];
                DataType rdt = dt = this.getDataType(datatype);
                if (dt == DataType.ARRAY) {
                    try {
                        rdt = DataType.values()[arraytype];
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new ParseException("Invalid inner type " + arraytype);
                    }
                }
                if ((ct = ContentTypeImpl.getBuiltIn(contenttype)) != null && !ct.isCompatible(rdt)) {
                    throw new ParseException("Incompatible types found: " + (Object)((Object)rdt) + " != " + ct);
                }
                if (ct == null) {
                    ct = new ContentTypeImpl(contenttype, null, null){
                        private ContentTypeImpl ct;

                        private ContentTypeImpl get() {
                            if (this.ct == null) {
                                this.ct = ChunkParser.this.contentDescs.get((Object)Integer.valueOf((int)this.getOrdinal())).contentType;
                            }
                            return this.ct;
                        }

                        public String getName() {
                            return this.get().getName();
                        }

                        public DataType getType() {
                            return this.get().getType();
                        }

                        public String toString() {
                            return this.get().toString();
                        }
                    };
                }
                String relation = null;
                if (dt.isPrimitive() && arraytype > 0) {
                    relation = (String)relations.get(arraytype - 1);
                }
                try {
                    descs[i] = new ValueData(pid, ns, id, name, desc, relation, tt, dt, ct, arraytype);
                    continue;
                }
                catch (InvalidValueException e) {
                    throw new ParseException("Could not read value", e);
                }
            }
            structList.add(descs);
            this.structs.put(this.structs.size() + 1, descs);
        }
        m = this.input.getInt();
        ArrayList<EventData> events = new ArrayList<EventData>(m);
        while (m-- > 0) {
            int eid = this.input.getInt();
            String name = this.readUTF();
            String desc = this.readUTF();
            String path = this.readUTF();
            boolean hasStartTime = this.input.get() != 0;
            boolean hasThread = this.input.get() != 0;
            boolean canHaveStacktrace = this.input.get() != 0;
            boolean isRequestable = this.input.get() != 0;
            int structindex = this.input.getInt();
            this.input.getInt();
            ValueData[] struct = structList.get(structindex);
            if (hasStartTime || hasThread || canHaveStacktrace) {
                ArrayList<ValueData> l = new ArrayList<ValueData>(struct.length + 3);
                try {
                    if (hasStartTime) {
                        l.add(new ValueData(pid, ns, START_TIME_ID, "Start time", "", null, Transition.None, ContentTypeImpl.MILLIS.getType(), ContentTypeImpl.MILLIS, 0));
                    }
                    if (hasThread) {
                        l.add(new ValueData(pid, ns, EVENT_THREAD_ID, "Event thread", null, "", Transition.None, ContentTypeImpl.OSTHREAD.getType(), ContentTypeImpl.OSTHREAD, 0));
                    }
                    if (canHaveStacktrace) {
                        l.add(new ValueData(pid, ns, STACKTRACE_ID, "Stacktrace", "", null, Transition.None, ContentTypeImpl.STACKTRACE.getType(), ContentTypeImpl.STACKTRACE, 0));
                    }
                }
                catch (InvalidValueException e) {
                    throw new ParseException("Could not read event " + name, e);
                }
                l.addAll(Arrays.asList(struct));
                struct = l.toArray(new ValueData[l.size()]);
            }
            try {
                d = new EventData(pid, uri, ns, name, desc, path, hasStartTime, hasThread, canHaveStacktrace, hasStartTime, isRequestable, eid, struct);
                this.eventTypes.put(eid, (EventData)d);
                events.add((EventData)d);
            }
            catch (InvalidEventDefinitionException e) {
                throw new ParseException("Could not read event", e);
            }
            catch (InvalidValueException e) {
                throw new ParseException("Could not read event", e);
            }
        }
        m = this.input.getInt();
        HashMap<Integer, ContentTypeDescriptor> contentTypes = new HashMap<Integer, ContentTypeDescriptor>();
        ProducerData p = new ProducerData(pid, pname, pdesc, uri, ns, events, contentTypes, structList);
        int index = 0;
        while (m-- > 0) {
            int cid = this.input.getInt();
            String cname = this.readUTF();
            String cdesc = this.readUTF();
            datatype = this.input.get();
            int structindex = this.input.getInt();
            DataType dt = this.getDataType(datatype);
            ContentTypeImpl ct = ContentTypeImpl.getBuiltIn(cid);
            if (ct == null) {
                ct = new ContentTypeImpl(cid, dt, cname);
            }
            d = new ContentTypeDescriptor(ct, cdesc, index++, p, structindex);
            this.contentDescs.put(cid, (ContentTypeDescriptor)d);
            contentTypes.put(cid, (ContentTypeDescriptor)d);
        }
        this.producers.put(pid, p);
    }

    static String xmlName(String path, String name) {
        StringBuilder buf = new StringBuilder();
        if (path.length() > 0) {
            buf.append(path);
        } else {
            buf.append(name);
        }
        int n = buf.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char x = c = buf.charAt(i);
            if (i == 0 && !Character.isUnicodeIdentifierStart(c)) {
                x = '_';
            }
            if (i != 0 && !Character.isUnicodeIdentifierPart(c)) {
                x = '_';
            }
            if (c == x) continue;
            buf.setCharAt(i, x);
        }
        return buf.toString();
    }
}

