/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.DataType;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Transition;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.jrockit.jfr.events.ContentTypeImpl;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.EventData;
import oracle.jrockit.jfr.parser.EventProxy;
import oracle.jrockit.jfr.parser.FLRStruct;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.ValueData;

class BufferLostEvent
extends EventProxy {
    static final ValueData[] struct = new ValueData[2];
    static final EventData eventData;

    public BufferLostEvent(ChunkParser chunkParser, long timestamp, Object[] values) {
        super(chunkParser, 2, timestamp, values);
    }

    public long getProducerId() {
        return 0L;
    }

    protected ProducerData producer() {
        return null;
    }

    protected EventData eventData() {
        return eventData;
    }

    String producerURI() {
        return "http://www.oracle.com/jrockit/jfr/";
    }

    protected ValueData[] valueData() {
        return struct;
    }

    public String getDescription() {
        return "Could not transfer from thread local buffer to global";
    }

    public String getName() {
        return "Buffer Lost";
    }

    public String getPath() {
        return "threadbuffer_lost";
    }

    public FLRStruct getStackTrace() {
        return null;
    }

    public long getStartTime() {
        return 0L;
    }

    public int getThreadId() {
        return (Integer)this.getValue(0);
    }

    public FLRStruct getThread() {
        return (FLRStruct)this.getResolvedValue(0);
    }

    public URI getURI() {
        try {
            return new URI(this.producerURI() + this.getPath());
        }
        catch (URISyntaxException e) {
            throw new InternalError();
        }
    }

    public boolean hasStackTrace() {
        return false;
    }

    public boolean hasStartTime() {
        return false;
    }

    public boolean hasThread() {
        return true;
    }

    static {
        try {
            BufferLostEvent.struct[0] = new ValueData(0, "jfr", "_thread", "Event thread", null, null, Transition.None, ContentTypeImpl.OSTHREAD.getType(), ContentTypeImpl.OSTHREAD, 0);
            BufferLostEvent.struct[1] = new ValueData(0, "jfr", "bytes", "Bytes lost", null, null, Transition.None, DataType.U4, ContentTypeImpl.BYTES, 0);
            eventData = new EventData(0, new URI("http://www.oracle.com/jrockit/jfr/"), "jfr", "BufferLost", "Thread buffer data lost", "bufferlost", false, true, false, false, false, 2, struct);
        }
        catch (InvalidEventDefinitionException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidValueException e) {
            throw new RuntimeException(e);
        }
    }
}

