/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.parser;

import com.oracle.jrockit.jfr.DataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import oracle.jrockit.jfr.parser.ChunkParser;
import oracle.jrockit.jfr.parser.ContentTypeDescriptor;
import oracle.jrockit.jfr.parser.FLRStruct;
import oracle.jrockit.jfr.parser.FLRValueInfo;
import oracle.jrockit.jfr.parser.ProducerData;
import oracle.jrockit.jfr.parser.SubStruct;
import oracle.jrockit.jfr.parser.ValueData;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractStructProxy
implements FLRStruct {
    protected final ChunkParser chunkParser;
    protected final Object[] values;

    public AbstractStructProxy(ChunkParser chunkParser, Object[] values) {
        this.chunkParser = chunkParser;
        this.values = values;
    }

    @Override
    public Object getValue(int index) {
        return this.values[index];
    }

    private Object resolveValue(Object o, ValueData d) {
        int ct = d.getContentTypeOrdinal();
        if (o == null || ct <= 6 || ct == 11) {
            return o;
        }
        long timestamp = this.timestamp();
        Object[] content = this.chunkParser.resolve(ct, (Number)o, timestamp);
        if (content == null) {
            return null;
        }
        ContentTypeDescriptor desc = this.chunkParser.contentDescs.get(ct);
        return new SubStruct(this.chunkParser, content, desc.producer.id, timestamp, desc.structIndex);
    }

    @Override
    public Object getResolvedValue(int index) {
        Object o = this.values[index];
        ValueData d = this.valueData()[index];
        DataType dt = d.getDataType();
        switch (dt) {
            default: {
                return this.resolveValue(o, d);
            }
            case ARRAY: {
                Object[] v = (Object[])o;
                Object[] res = new Object[v.length];
                for (int j = 0; j < v.length; ++j) {
                    res[j] = this.resolveValue(v[j], d);
                }
                return res;
            }
            case STRUCT: {
                return new SubStruct(this.chunkParser, (Object[])o, this.producer().id, this.timestamp(), d.getInnerType());
            }
            case STRUCTARRAY: 
        }
        Object[] v = (Object[])o;
        FLRStruct[] res = new FLRStruct[v.length];
        for (int j = 0; j < v.length; ++j) {
            res[j] = new SubStruct(this.chunkParser, (Object[])v[j], this.producer().id, this.timestamp(), d.getInnerType());
        }
        return res;
    }

    @Override
    public List<?> getResolvedValues() {
        int n = this.values.length;
        ArrayList<Object> l = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            l.add(this.getResolvedValue(i));
        }
        return l;
    }

    protected abstract long timestamp();

    protected abstract ProducerData producer();

    protected abstract ValueData[] valueData();

    private Object getValue(String id, boolean resolve) {
        ValueData[] struct = this.valueData();
        int i = 0;
        for (ValueData d : struct) {
            if (d.getId().equals(id)) {
                return resolve ? this.getResolvedValue(i) : this.getValue(i);
            }
            ++i;
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public FLRValueInfo getValueInfo(int index) {
        return this.valueData()[index];
    }

    @Override
    public FLRValueInfo getValueInfo(String id) {
        for (ValueData d : this.valueData()) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        throw new NoSuchElementException(id);
    }

    @Override
    public final Object getValue(String id) {
        return this.getValue(id, false);
    }

    @Override
    public final Object getResolvedValue(String id) {
        return this.getValue(id, true);
    }

    @Override
    public List<?> getValues() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<? extends FLRValueInfo> getValueInfos() {
        return Arrays.asList(this.valueData());
    }

    String producerURI() {
        return this.producer().uri.toString();
    }

    void xmlSnippet(ContentHandler h) throws SAXException {
        ValueData[] data = this.valueData();
        String uri = this.producerURI();
        int i = 0;
        int n = data.length;
        for (ValueData d : data) {
            Object o = this.getResolvedValue(i);
            if (n > 1) {
                h.startElement(uri, d.xmlname, d.qname, ChunkParser.empty);
            }
            switch (d.getDataType()) {
                case ARRAY: {
                    Object s;
                    Object[] v2;
                    for (Object e : v2 = (Object[])o) {
                        h.startElement("http://www.oracle.com/jrockit/jfr/", "elem", "jfr:elem", ChunkParser.empty);
                        s = String.valueOf(e);
                        h.characters(((String)s).toCharArray(), 0, ((String)s).length());
                        h.endElement("http://www.oracle.com/jrockit/jfr/", "elem", "jfr:elem");
                    }
                    break;
                }
                case STRUCTARRAY: {
                    Object s;
                    Object[] v2;
                    for (Object e : v2 = (Object[])o) {
                        s = (AbstractStructProxy)e;
                        h.startElement("http://www.oracle.com/jrockit/jfr/", "elem", "jfr:elem", ChunkParser.empty);
                        ((AbstractStructProxy)s).xmlSnippet(h);
                        h.endElement("http://www.oracle.com/jrockit/jfr/", "elem", "jfr:elem");
                    }
                    break;
                }
                default: {
                    Object s;
                    if (o instanceof FLRStruct) {
                        s = (AbstractStructProxy)o;
                        ((AbstractStructProxy)s).xmlSnippet(h);
                        break;
                    }
                    s = String.valueOf(o);
                    h.characters(((String)s).toCharArray(), 0, ((String)s).length());
                }
            }
            if (n > 1) {
                h.endElement(uri, d.xmlname, d.qname);
            }
            ++i;
        }
    }

    private void indent(StringBuilder buf, int indent) {
        for (int j = 0; j < indent; ++j) {
            buf.append("   ");
        }
    }

    void print(StringBuilder buf, int indent) {
        ValueData[] data = this.valueData();
        int i = 0;
        int n = data.length;
        if (n > 1) {
            buf.append("{\n");
        }
        for (ValueData d : data) {
            Object o = this.getResolvedValue(i);
            if (n > 1) {
                this.indent(buf, indent + 1);
                buf.append(d.getName()).append(" = ");
            }
            switch (d.getDataType()) {
                case ARRAY: {
                    Object[] v2 = (Object[])o;
                    buf.append(Arrays.toString(v2));
                    break;
                }
                case STRUCTARRAY: {
                    Object[] v2 = (Object[])o;
                    int k = 0;
                    for (Object e : v2) {
                        AbstractStructProxy s = (AbstractStructProxy)e;
                        s.print(buf, indent + 1);
                        if (++k >= v2.length) continue;
                        buf.append(",\n");
                        this.indent(buf, indent + 1);
                    }
                    break;
                }
                default: {
                    if (o instanceof FLRStruct) {
                        AbstractStructProxy s = (AbstractStructProxy)o;
                        s.print(buf, indent + 1);
                        break;
                    }
                    buf.append(o);
                    this.describeValue(buf, d, o);
                }
            }
            ++i;
            if (n <= 1) continue;
            buf.append('\n');
        }
        if (n > 1) {
            this.indent(buf, indent);
            buf.append("}");
        }
    }

    private void describeValue(StringBuilder buf, ValueData d, Object o) {
        if (d.getContentTypeImpl().getOrdinal() == 5) {
            buf.append(" (");
            buf.append(this.chunkParser.ticksToMillis((Long)o));
            buf.append(" ms)");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.print(buf, 0);
        return buf.toString();
    }
}

