/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.openmbean;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import oracle.jrockit.jfr.openmbean.JFRMBeanType;
import oracle.jrockit.jfr.openmbean.Member;
import sun.management.LazyCompositeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LazyImmutableJFRMBeanType<T>
extends JFRMBeanType<T> {
    private final Class<T> type;

    LazyImmutableJFRMBeanType(Class<T> type, String name, String desc, Member<?> ... members) throws OpenDataException {
        super(name, desc, members);
        this.type = type;
    }

    LazyImmutableJFRMBeanType(Class<T> type, String name, String desc, String[] names, String[] descriptions, OpenType[] types) throws OpenDataException {
        super(name, desc, names, descriptions, types);
        this.type = type;
    }

    @Override
    public final CompositeData toCompositeTypeData(T t) throws OpenDataException {
        return new ImmutableCompositeData(t);
    }

    @Override
    public final T toJavaTypeData(CompositeData d) throws OpenDataException {
        if (ImmutableCompositeData.class.isInstance(d)) {
            try {
                return this.type.cast(((ImmutableCompositeData)d).data);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this.toJavaTypeDataLazy(d);
    }

    protected abstract CompositeData toCompositeTypeDataLazy(T var1) throws OpenDataException;

    protected abstract T toJavaTypeDataLazy(CompositeData var1) throws OpenDataException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ImmutableCompositeData
    extends LazyCompositeData {
        private final T data;

        public ImmutableCompositeData(T data) {
            this.data = data;
        }

        @Override
        protected CompositeData getCompositeData() {
            try {
                return LazyImmutableJFRMBeanType.this.toCompositeTypeDataLazy(this.data);
            }
            catch (OpenDataException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
        }

        @Override
        public CompositeType getCompositeType() {
            return LazyImmutableJFRMBeanType.this.getType();
        }
    }
}

