/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.openmbean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import oracle.jrockit.jfr.openmbean.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JFRMBeanType<T> {
    private final String[] names;
    private final CompositeType type;

    JFRMBeanType(String name, String desc, String[] names, String[] descriptions, OpenType[] types) throws OpenDataException {
        this.names = names;
        this.type = new CompositeType(name, desc, names, descriptions, types);
    }

    JFRMBeanType(String name, String desc, Member<?> ... members) throws OpenDataException {
        int n = members.length;
        this.names = new String[n];
        String[] descriptions = new String[n];
        OpenType[] types = new OpenType[n];
        for (int i = 0; i < n; ++i) {
            this.names[i] = members[i].name;
            descriptions[i] = members[i].description;
            types[i] = members[i].openType;
        }
        this.type = new CompositeType(name, desc, this.names, descriptions, types);
    }

    public final String[] getNames() {
        return this.names;
    }

    public final CompositeType getType() {
        return this.type;
    }

    public abstract CompositeData toCompositeTypeData(T var1) throws OpenDataException;

    public List<CompositeData> toCompositeData(Collection<? extends T> c) throws OpenDataException {
        ArrayList<CompositeData> result = new ArrayList<CompositeData>(c.size());
        for (T t : c) {
            result.add(this.toCompositeTypeData(t));
        }
        return result;
    }

    public T toJavaTypeData(CompositeData d) throws OpenDataException {
        throw new OpenDataException("Cannot construct java types for " + this.getType().getTypeName());
    }

    public List<T> toJavaTypeData(Collection<CompositeData> c) throws OpenDataException {
        ArrayList<T> result = new ArrayList<T>(c.size());
        for (CompositeData d : c) {
            result.add(this.toJavaTypeData(d));
        }
        return result;
    }

    protected final OpenDataException openDataException(String msg, Throwable t) {
        return (OpenDataException)new OpenDataException(msg).initCause(t);
    }

    protected final OpenDataException openDataException(Throwable t) {
        return this.openDataException(t.getMessage(), t);
    }

    protected final boolean booleanAt(CompositeData d, Member<Boolean> m) {
        return (Boolean)d.get(m.name);
    }

    protected final int intAt(CompositeData d, Member<Integer> m) {
        return ((Number)d.get(m.name)).intValue();
    }

    protected final long longAt(CompositeData d, Member<Long> m) {
        return ((Number)d.get(m.name)).longValue();
    }

    protected final String stringAt(CompositeData d, Member<String> m) {
        return (String)d.get(m.name);
    }

    protected final Date dateAt(CompositeData d, Member<Date> m) {
        return (Date)d.get(m.name);
    }
}

