/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.openmbean;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.openmbean.LazyImmutableJFRMBeanType;
import oracle.jrockit.jfr.openmbean.Member;
import oracle.jrockit.jfr.settings.EventSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSettingType
extends LazyImmutableJFRMBeanType<EventSetting> {
    static final Member<Integer> ID = new Member("id", "Event ID", SimpleType.INTEGER);
    static final Member<Boolean> ENABLED = new Member("enabled", "Is event type enabled", SimpleType.BOOLEAN);
    static final Member<Boolean> STACKTRACE = new Member("stacktrace", "Is stacktrace recording enabled for event type", SimpleType.BOOLEAN);
    static final Member<Long> THRESHOLD = new Member("threshold", "Timing threshold for recording event type", SimpleType.LONG);
    static final Member<Long> PERIOD = new Member("requestPeriod", "Period for auto generating event type (ms)", SimpleType.LONG);
    private final JFRImpl jfrImpl;

    public EventSettingType(JFRImpl jfrImpl) throws OpenDataException {
        super(EventSetting.class, "EventSetting", "Event setting", ID, ENABLED, STACKTRACE, THRESHOLD, PERIOD);
        this.jfrImpl = jfrImpl;
    }

    @Override
    public CompositeData toCompositeTypeDataLazy(EventSetting t) throws OpenDataException {
        return new CompositeDataSupport(this.getType(), this.getNames(), new Object[]{t.getId(), t.isEnabled(), t.isStacktraceEnabled(), t.getThreshold(), t.getPeriod()});
    }

    @Override
    public EventSetting toJavaTypeDataLazy(CompositeData d) throws OpenDataException {
        try {
            int id = this.intAt(d, ID);
            EventDescriptor e = this.jfrImpl.getEvent(id);
            return new EventSetting(e, this.booleanAt(d, ENABLED), this.booleanAt(d, STACKTRACE), this.longAt(d, THRESHOLD), this.longAt(d, PERIOD));
        }
        catch (Exception e) {
            throw this.openDataException(e);
        }
    }
}

