/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.openmbean;

import java.net.URI;
import java.net.URISyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import oracle.jrockit.jfr.openmbean.EventSettingType;
import oracle.jrockit.jfr.openmbean.LazyImmutableJFRMBeanType;
import oracle.jrockit.jfr.openmbean.Member;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDefaultType
extends LazyImmutableJFRMBeanType<EventDefault> {
    static final Member<String> PATTERN = new Member("pattern", "URI pattern", SimpleType.STRING);

    public EventDefaultType() throws OpenDataException {
        super(EventDefault.class, "EventDefault", "Event defaults", PATTERN, EventSettingType.ENABLED, EventSettingType.STACKTRACE, EventSettingType.THRESHOLD, EventSettingType.PERIOD);
    }

    @Override
    public CompositeData toCompositeTypeDataLazy(EventDefault d) throws OpenDataException {
        EventSetting t = d.getSetting();
        try {
            return new CompositeDataSupport(this.getType(), this.getNames(), new Object[]{d.getPattern().toString(), t.isEnabled(), t.isStacktraceEnabled(), t.getThreshold(), t.getPeriod()});
        }
        catch (OpenDataException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    @Override
    public EventDefault toJavaTypeDataLazy(CompositeData d) throws OpenDataException {
        EventSetting s = new EventSetting(0, this.booleanAt(d, EventSettingType.ENABLED), this.booleanAt(d, EventSettingType.STACKTRACE), this.longAt(d, EventSettingType.THRESHOLD), this.longAt(d, EventSettingType.PERIOD));
        try {
            return new EventDefault(new URI(this.stringAt(d, PATTERN)), s);
        }
        catch (URISyntaxException e) {
            throw this.openDataException(e);
        }
    }
}

