/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.ValueDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProducerDescriptor
implements ProducerDescriptor {
    private final int id;
    private final List<JavaEventDescriptor> events;
    private final Collection<? extends EventDescriptor> publicEvents;
    private final String name;
    private final String description;
    private final URI uri;
    private final ByteBuffer binaryDescriptor;

    public JavaProducerDescriptor(int id, String name, String descriptor, URI uri, List<JavaEventDescriptor> events, Map<String, StringConstantPool> pools) {
        this.id = id;
        this.events = events;
        this.name = name;
        this.description = descriptor;
        this.uri = uri;
        this.binaryDescriptor = this.createBinaryDescriptor(pools);
        this.publicEvents = Collections.unmodifiableCollection(events);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Collection<? extends EventDescriptor> getEvents() {
        return this.publicEvents;
    }

    @Override
    public ByteBuffer getBinaryDescriptor() {
        return this.binaryDescriptor;
    }

    @Override
    public long writeCheckPoint(FileChannel channel, long previous) {
        return previous;
    }

    private ByteBuffer createBinaryDescriptor(Map<String, StringConstantPool> pools) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(this.events.size() * 200 + pools.size() * 50);
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeInt(this.id);
            out.writeUTF(this.name);
            out.writeUTF(this.description);
            out.writeUTF(this.uri.toString());
            ArrayList<String> l = new ArrayList<String>();
            HashMap<String, Integer> relations = new HashMap<String, Integer>();
            int relation = 0;
            for (JavaEventDescriptor e : this.events) {
                for (ValueDescriptor d : e.getValues()) {
                    String s = d.getRelationKey();
                    if (s == null || relations.containsKey(s)) continue;
                    relations.put(s, ++relation);
                    l.add(s);
                }
            }
            out.writeInt(relations.size());
            for (String s : l) {
                out.writeUTF(s);
            }
            int numDatatypes = 0;
            if (!pools.isEmpty()) {
                ++numDatatypes;
            }
            out.writeInt(numDatatypes += this.events.size());
            for (JavaEventDescriptor e : this.events) {
                int n = e.getValues().length;
                out.writeInt(n);
                for (ValueDescriptor d : e.getValues()) {
                    out.writeUTF(d.getId());
                    out.writeUTF(d.getName());
                    out.writeUTF(d.getDescription());
                    out.write(d.getTransition().value());
                    DataType t = d.getDataType();
                    int ct = d.getContentTypeOrdinal();
                    if (t == DataType.STRING && d.getConstantPool() != null && pools.containsKey(d.getConstantPool())) {
                        t = DataType.INTEGER;
                        ct = pools.get(d.getConstantPool()).getConstantIndex();
                    }
                    out.write(t.ordinal());
                    out.writeInt(ct);
                    String s = d.getRelationKey();
                    if (s == null) {
                        out.writeInt(0);
                    } else {
                        out.writeInt((Integer)relations.get(s));
                    }
                    out.writeInt(0);
                }
            }
            if (!pools.isEmpty()) {
                out.writeInt(1);
                out.writeUTF("utf");
                out.writeUTF("String");
                out.writeUTF("");
                out.write(0);
                out.write(DataType.UTF8.ordinal());
                out.writeInt(0);
                out.writeInt(0);
                out.writeInt(0);
            }
            out.writeInt(this.events.size());
            int i = 0;
            for (JavaEventDescriptor javaEventDescriptor : this.events) {
                out.writeInt(javaEventDescriptor.getId());
                out.writeUTF(javaEventDescriptor.getName());
                out.writeUTF(javaEventDescriptor.getDescription());
                out.writeUTF(javaEventDescriptor.getPath());
                out.writeBoolean(javaEventDescriptor.hasStartTime());
                out.writeBoolean(javaEventDescriptor.hasThread());
                out.writeBoolean(javaEventDescriptor.hasStackTrace());
                out.writeBoolean(javaEventDescriptor.isRequestable());
                out.writeInt(i++);
                out.writeInt(0);
            }
            out.writeInt(pools.size());
            for (Map.Entry entry : pools.entrySet()) {
                String name = (String)entry.getKey();
                StringConstantPool p = (StringConstantPool)entry.getValue();
                out.writeInt(p.getConstantIndex());
                out.writeUTF(name);
                out.writeUTF("");
                out.write(DataType.INTEGER.ordinal());
                out.writeInt(this.events.size());
            }
            out.flush();
            out.close();
            byte[] bytes = bout.toByteArray();
            return ByteBuffer.wrap(bytes);
        }
        catch (IOException e) {
            throw (InternalError)new InternalError("Could not create descriptors").initCause(e);
        }
    }
}

