/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.UseConstantPool;
import com.oracle.jrockit.jfr.ValueDefinition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import oracle.jrockit.jfr.events.ValueDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStructureDescriptor {
    private final ValueDescriptor[] values;
    private final HashMap<String, Integer> idToIndexMap = new HashMap();

    public DataStructureDescriptor(Class<?> c) throws InvalidValueException {
        ArrayList<ValueDescriptor> values = new ArrayList<ValueDescriptor>();
        while (true) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                ValueDefinition d = f.getAnnotation(ValueDefinition.class);
                UseConstantPool p = f.getAnnotation(UseConstantPool.class);
                if (d == null) continue;
                values.add(new ValueDescriptor(d, p, f));
            }
            Class<?> s = c.getSuperclass();
            if (!InstantEvent.class.isAssignableFrom(s)) break;
            c = s.asSubclass(InstantEvent.class);
        }
        Collections.reverse(values);
        this.values = values.toArray(new ValueDescriptor[values.size()]);
        int i = 0;
        for (ValueDescriptor d : values) {
            this.idToIndexMap.put(d.getId(), i++);
        }
    }

    public DataStructureDescriptor(ValueDescriptor ... values) {
        this.values = values;
        int i = 0;
        for (ValueDescriptor d : values) {
            this.idToIndexMap.put(d.getId(), i++);
        }
    }

    public ValueDescriptor[] getValues() {
        return this.values;
    }

    public int valueIndex(String valueId) {
        Integer i = this.idToIndexMap.get(valueId);
        if (i != null) {
            return i;
        }
        throw new IllegalArgumentException("No value field with id " + valueId);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

