/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.client.EventSettingsBuilder;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.NativeJFRStats;
import oracle.jrockit.jfr.NativeProducerDescriptor;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.os.Process;
import oracle.jrockit.os.Timing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VMJFR
extends JFRImpl {
    private static final int addressSize = Integer.parseInt(System.getProperty("sun.arch.data.model")) / 8;
    private final NativeProducerDescriptor vm;
    private final NativeJFRStats jfrStats;
    static final int PREV = 0;
    static final int NEXT = 1 * addressSize;
    static final int START = 2 * addressSize;
    static final int TOP = 3 * addressSize;
    static final int POS = 4 * addressSize;
    static final int END = 5 * addressSize;
    static final int USED = 6 * addressSize;
    static final int RESERVED = USED + 4;
    static final int DATA = RESERVED + 4;
    private final ThreadLocal<ThreadBuffer> bufferLocal = new ThreadLocal<ThreadBuffer>(){

        @Override
        protected ThreadBuffer initialValue() {
            return new ThreadBuffer(VMJFR.this.buffer());
        }
    };

    VMJFR() {
        super(VMJFR.options());
        ByteBuffer statsbuf = this.init(Locale.getDefault().toString(), TimeZone.getDefault().getRawOffset(), this.getRepository().getPath().getPath());
        this.jfrStats = new NativeJFRStats(statsbuf.order(ByteOrder.nativeOrder()));
        try {
            this.vm = new NativeProducerDescriptor(1, this);
        }
        catch (Exception e) {
            throw (Error)new InternalError().initCause(e);
        }
        this.addProducer(this.vm, this.vm.controls());
        this.startDefaultRecording();
    }

    private static native Options options();

    private native ByteBuffer init(String var1, int var2, String var3);

    @Override
    public boolean isNativeImplementation() {
        return true;
    }

    @Override
    public ByteBuffer getThreadBuffer(int neededSize) {
        return this.bufferLocal.get().ensure(neededSize);
    }

    @Override
    public void releaseThreadBuffer(ByteBuffer buf, boolean ok) {
        this.bufferLocal.get().finish(buf, ok);
    }

    private native void addConstPool(ByteBuffer var1, int var2, boolean var3);

    private native void removeConstPool(int var1);

    private native boolean storeConstPool(int var1);

    @Override
    protected void addConstpool(StringConstantPool pool) {
        this.addConstPool(pool.getConstantData(), pool.getConstantIndex(), pool.emptyOnRotation());
    }

    @Override
    protected void removeConstpool(StringConstantPool pool) {
        this.removeConstPool(pool.getConstantIndex());
    }

    @Override
    protected boolean storeConstpool(StringConstantPool pool) {
        return this.storeConstPool(pool.getConstantIndex());
    }

    @Override
    public native long classID(Class<?> var1);

    @Override
    public long counterTime() {
        return Timing.counterTime();
    }

    @Override
    public long nanoToCounter(long ct) {
        return Timing.nanoToCounter(ct);
    }

    @Override
    public native long stackTraceID(int var1);

    @Override
    public native int threadID();

    @Override
    public int getpid() {
        return Process.current.pid();
    }

    @Override
    public JFRStats getJFRStats() {
        return this.jfrStats;
    }

    @Override
    protected native void rotate();

    @Override
    protected native void shutdown();

    @Override
    protected native void start(boolean var1);

    @Override
    protected native void stop();

    private native ByteBuffer buffer();

    private native void flush();

    private native void write(byte[] var1, int var2, int var3);

    private native void add(int var1, byte[] var2, int var3, int var4);

    private native void remove(int var1);

    native void setEnabled(int var1, boolean var2);

    native void setThreshold(int var1, long var2);

    native void setPeriod(int var1, long var2);

    native long getPeriod(int var1);

    native int descriptors(int var1, ByteBuffer[] var2);

    @Override
    protected void add(ProducerDescriptor d) {
        if (d == this.vm) {
            return;
        }
        ByteBuffer buf = d.getBinaryDescriptor();
        this.add(d.getId(), buf.array(), buf.arrayOffset(), buf.capacity());
    }

    @Override
    protected void remove(ProducerDescriptor d) {
        if (d == this.vm) {
            return;
        }
        this.remove(d.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishChunk(String path, long startTime, long endTime, boolean newChunk) throws IOException {
        RepositoryChunk chunk = new RepositoryChunk(this.getRepository(), this.logger, new File(path));
        try {
            chunk.finish(startTime, endTime);
            this.addChunk(chunk);
        }
        finally {
            chunk.release();
            chunk = null;
            this.chunkDone();
        }
    }

    private long startRecording(String name, String[] settings, boolean defaultRecording, long delay, long duration, String dest, boolean compress, long maxage, long maxsize) throws Throwable {
        FlightRecorderClient fr = new FlightRecorderClient();
        if (defaultRecording) {
            fr.enableDefaultRecording();
            if (settings != null) {
                for (int i = 0; i < settings.length; ++i) {
                    this.loadDefaultSettings(this.getEventSettings(), settings[i]);
                }
            }
            return 0L;
        }
        if (dest != null && name == null) {
            File f = new File(dest);
            name = f.getName();
        }
        FlightRecordingClient r = fr.createRecordingObject(name);
        try {
            if (settings != null) {
                EventSettingsBuilder b = new EventSettingsBuilder();
                for (int i = 0; i < settings.length; ++i) {
                    b.addSettings(this.findEventDefaultSet(settings[i]));
                }
                r.addEventDefaults(b.createDefaultSettings());
            }
            if (duration != 0L) {
                duration = Math.max(1000L, TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS));
            }
            if (delay != 0L) {
                delay = TimeUnit.MILLISECONDS.convert(delay, TimeUnit.NANOSECONDS);
            }
            if (maxage != 0L) {
                maxage = TimeUnit.MILLISECONDS.convert(maxage, TimeUnit.NANOSECONDS);
            }
            r.setDuration(duration);
            r.setDestination(dest);
            r.setDestinationCompressed(compress);
            r.setMaxAge(maxage);
            r.setMaxSize(maxsize);
            if (delay != 0L) {
                r.setStartTime(new Date(System.currentTimeMillis() + delay));
            } else {
                r.start();
            }
        }
        catch (Throwable t) {
            r.close();
            throw t;
        }
        return r.getId();
    }

    private FlightRecordingClient findRecording(String name, long id) throws InstanceNotFoundException, NullPointerException, IOException, OpenDataException, NoSuchRecordingException {
        FlightRecorderClient fr = new FlightRecorderClient();
        List<FlightRecordingClient> l = fr.getRecordingObjects();
        for (FlightRecordingClient r : l) {
            if ((id != -1L || name == null || !name.equals(r.getName())) && r.getId() != id) continue;
            return r;
        }
        throw new NoSuchRecordingException(name + ":" + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRecording(String name, long id, boolean discard, String copyTo, boolean copyCompressed) throws NoSuchRecordingException, IOException, OpenDataException, InstanceNotFoundException, NullPointerException {
        FlightRecordingClient r = this.findRecording(name, id);
        try {
            if (discard) {
                r.setDestination(null);
            }
            r.setStartTime(null);
            r.stop();
            if (copyTo != null) {
                r.copyTo(copyTo, copyCompressed);
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRecording(String name, long id, String copyTo, boolean copyCompressed) throws InstanceNotFoundException, NullPointerException, IOException, OpenDataException, NoSuchRecordingException {
        if (copyTo == null) {
            throw new NullPointerException("copyTo");
        }
        FlightRecordingClient r = this.findRecording(name, id);
        FlightRecordingClient copy = r.cloneRecordingObject(name + "_copy_" + System.nanoTime(), true);
        try {
            copy.copyTo(copyTo, copyCompressed);
        }
        finally {
            copy.close();
        }
    }

    private String checkRecording(String name, long id, boolean verbose) throws NoSuchRecordingException, InstanceNotFoundException, NullPointerException, OpenDataException, IOException {
        if (id != -1L || name != null) {
            FlightRecordingClient r = this.findRecording(name, id);
            return this.printRecording(this.getRecording(r.getId()), verbose);
        }
        StringBuilder buf = new StringBuilder();
        FlightRecorderClient fr = new FlightRecorderClient();
        for (FlightRecordingClient r : fr.getRecordingObjects()) {
            try {
                buf.append(this.printRecording(this.getRecording(r.getId()), verbose));
                buf.append('\n');
            }
            catch (NoSuchRecordingException e) {}
        }
        return buf.toString();
    }

    private String printRecording(Recording r, boolean verbose) {
        StringBuilder buf = new StringBuilder();
        buf.append("Recording : id=" + r.getId() + " name=\"" + r.getName() + "\" duration=" + r.getDuration(TimeUnit.SECONDS) + "s");
        String dest = r.getDestination();
        if (dest != null) {
            buf.append(" dest=\"" + dest + "\" compress=" + r.isDestinationCompressed());
        }
        if (!r.isStarted()) {
            buf.append(" (unstarted)");
        }
        if (r.isRunning()) {
            buf.append(" (running)");
        }
        if (r.isStopped()) {
            buf.append(" (stopped)");
        }
        if (!verbose) {
            return buf.toString();
        }
        buf.append('\n');
        Collection<EventDescriptor> descriptors = this.getEvents();
        Collection<EventSetting> settings = r.getEventSettings().getSettings();
        TreeMap<String, EventDescriptor> sorted = new TreeMap<String, EventDescriptor>();
        for (EventDescriptor d : descriptors) {
            sorted.put(d.getURI().toString(), d);
        }
        HashMap<Integer, EventSetting> map = new HashMap<Integer, EventSetting>();
        for (EventSetting s : settings) {
            map.put(s.getId(), s);
        }
        String base = null;
        for (Map.Entry e : sorted.entrySet()) {
            EventSetting s;
            String uri = (String)e.getKey();
            EventDescriptor d = (EventDescriptor)e.getValue();
            if (base == null || !uri.startsWith(base)) {
                base = uri.substring(0, uri.length() - d.getPath().length());
                buf.append(base).append(":\n");
            }
            if ((s = (EventSetting)map.get(d.getId())) == null) continue;
            buf.append('\t').append(d.getPath()).append(" : ");
            buf.append(s.isEnabled() ? "enabled" : "disabled");
            if (d.hasStackTrace() && s.isStacktraceEnabled()) {
                buf.append(" stacktrace");
            }
            if (d.isTimed()) {
                buf.append(" threshold=").append(s.getThreshold());
            }
            if (d.isRequestable()) {
                buf.append(" period=").append(s.getPeriod());
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    static JFR create() {
        return new VMJFR();
    }

    private final class ThreadBuffer {
        private final ByteBuffer base;
        private final ByteBuffer buffer;

        public ThreadBuffer(ByteBuffer buffer) {
            this.base = buffer.order(ByteOrder.nativeOrder());
            buffer.position(DATA);
            this.buffer = buffer.slice();
        }

        public void acquire() {
            this.base.put(USED, (byte)1);
        }

        public void release() {
            this.base.put(USED, (byte)0);
        }

        public void finish(ByteBuffer buf, boolean ok) {
            if (buf != this.buffer && ok) {
                buf.flip();
                VMJFR.this.write(buf.array(), buf.arrayOffset(), buf.limit());
                return;
            }
            if (ok) {
                int pos = this.buffer.position();
                if (addressSize == 8) {
                    long start = this.base.getLong(START);
                    this.base.putLong(POS, start + (long)pos);
                }
                if (addressSize == 4) {
                    int start = this.base.getInt(START);
                    this.base.putInt(POS, start + pos);
                }
            }
            this.release();
        }

        public ByteBuffer ensure(int size) {
            int pos;
            assert (size != 0);
            if (this.buffer.capacity() < size) {
                return ByteBuffer.allocate(size + 512);
            }
            while (true) {
                this.acquire();
                if (addressSize == 8) {
                    long pos2;
                    long end = this.base.getLong(END);
                    if (end - (pos2 = this.base.getLong(POS)) < (long)size) {
                        this.release();
                        VMJFR.this.flush();
                        continue;
                    }
                    int off = (int)(pos2 - this.base.getLong(START));
                    this.buffer.position(off);
                    return this.buffer;
                }
                if (addressSize != 4) continue;
                int end = this.base.getInt(END);
                if (end - (pos = this.base.getInt(POS)) >= size) break;
                this.release();
                VMJFR.this.flush();
            }
            int off = pos - this.base.getInt(START);
            this.buffer.position(off);
            return this.buffer;
        }
    }
}

