/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.log.Logger;

public class StringConstantPool {
    private final Logger logger = Logger.loggerFor("jfr");
    private final ConcurrentHashMap<String, Integer> mappings = new ConcurrentHashMap();
    private final ByteBuffer data;
    private final JFR jfr;
    private final DataOutputStream out;
    private final int constantIndex;
    private final boolean emptyOnRotation;
    private volatile boolean enabled = false;
    private volatile boolean bufferFull = false;
    private static final int POSITION = 0;
    private static final int OFFSET = 4;
    private static final int DATA = 8;

    public StringConstantPool(JFR jfr, int constantIndex, int maxSize, boolean emptyOnRoation) {
        this.jfr = jfr;
        this.constantIndex = constantIndex;
        this.emptyOnRotation = emptyOnRoation;
        if (maxSize == 0) {
            maxSize = 0x200000;
        }
        this.data = ByteBuffer.allocateDirect(maxSize);
        this.data.putInt(0, 0);
        this.data.putInt(4, 1);
        this.out = new DataOutputStream(new OutputStream(){

            public void write(byte[] b, int off, int len) throws IOException {
                int newPos;
                int next;
                int pos;
                if (len > StringConstantPool.this.data.capacity() - 12) {
                    throw new OutOfMemoryError("Too large string");
                }
                do {
                    pos = StringConstantPool.this.data.getInt(0);
                    next = StringConstantPool.this.data.getInt(pos);
                    if (pos == 0) {
                        StringConstantPool.this.data.position(8);
                        next = StringConstantPool.this.data.getInt(4);
                    } else {
                        StringConstantPool.this.data.position(pos);
                    }
                    StringConstantPool.this.data.putInt(next);
                    StringConstantPool.this.data.put(b, off, len);
                    newPos = StringConstantPool.this.data.position();
                } while (StringConstantPool.this.data.getInt(0) != pos);
                StringConstantPool.this.data.putInt(next + 1);
                StringConstantPool.this.data.putInt(0, newPos);
            }

            public void write(int b) throws IOException {
            }
        });
    }

    public synchronized void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.jfr.addConstpool(this);
        }
    }

    public synchronized void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.jfr.removeConstpool(this);
        }
    }

    public ByteBuffer getConstantData() {
        return this.data;
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    public boolean emptyOnRotation() {
        return this.emptyOnRotation;
    }

    public int asConstant(String s) {
        if (s == null) {
            return 0;
        }
        Integer i;
        int pos;
        while ((pos = this.data.getInt(0)) <= 0 || (i = this.mappings.get(s)) == null) {
            ByteBuffer byteBuffer = this.data;
            synchronized (byteBuffer) {
                pos = this.data.getInt(0);
                if (pos == 0) {
                    this.mappings.clear();
                } else {
                    i = this.mappings.get(s);
                    if (i != null) {
                        return i;
                    }
                }
                if (this.bufferFull) {
                    throw new OutOfMemoryError("String constant pool buffer full, and emptyOnRotation not set.");
                }
                try {
                    this.out.writeUTF(s);
                    pos = this.data.getInt(0);
                    if (pos == 0) {
                        continue;
                    }
                    int res = this.data.getInt(pos) - 1;
                    assert (res != 0);
                    this.mappings.put(s, res);
                    return res;
                }
                catch (BufferOverflowException e) {
                    this.logger.trace("String constant pool buffer full. Storing in chunk.");
                    if (!this.jfr.storeConstpool(this)) {
                        this.logger.info("String constant pool store failed.");
                        this.logger.trace("String constant pool store failed at: ", Thread.currentThread().getStackTrace());
                    }
                    if (!this.emptyOnRotation) {
                        this.bufferFull = true;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 6] lbl39 : MonitorExitStatement: MONITOREXIT : var4_4
                    continue;
                }
                catch (IOException e) {
                    throw new InternalError();
                }
            }
            break;
        }
        return i;
    }

    protected void finalize() throws Throwable {
        this.disable();
    }
}

