/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.EventInfo;
import com.oracle.jrockit.jfr.NoSuchEventException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.jrockit.jfr.MetaProducer;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Settings
implements EventSettings {
    private final Object lock;
    private final Map<Integer, EventControl> eventControls;
    private final Collection<Recording> recordings;
    private final MetaProducer metaProducer;
    private final HashMap<Integer, EventSetting> eventSettings = new HashMap();
    private final HashMap<Integer, EventSetting> disabledSettings = new HashMap();
    private final Aggregator globalAggregator = new Aggregator();

    Settings(Object eventLock, Map<Integer, EventControl> eventControls, Collection<Recording> recordings, MetaProducer metaProducer) {
        this.lock = eventLock;
        this.eventControls = eventControls;
        this.recordings = recordings;
        this.metaProducer = metaProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvents(Collection<? extends EventInfo> events) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Integer, EventSetting> map = new HashMap<Integer, EventSetting>();
            for (EventInfo eventInfo : events) {
                int id = eventInfo.getId();
                map.put(id, new EventSetting(id));
            }
            this.disabledSettings.putAll(map);
            this.globalAggregator.updateDefaults(events);
            for (Recording recording : this.recordings) {
                recording.settingsAggregator.updateDefaults(events);
            }
            this.update(map);
        }
    }

    private void update(HashMap<Integer, EventSetting> settings) {
        assert (Thread.holdsLock(this.lock));
        for (Recording recording : this.recordings) {
            if (!recording.isStarted() || recording.isStoppingDone()) continue;
            recording.settingsAggregator.mergeAll(settings);
        }
        for (Map.Entry entry : settings.entrySet()) {
            EventControl c = this.eventControls.get(entry.getKey());
            assert (c != null);
            c.apply((EventSetting)entry.getValue());
        }
        this.metaProducer.settingsChanged(settings.values(), this.eventSettings);
        this.eventSettings.putAll(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<Integer, EventSetting> map = new HashMap<Integer, EventSetting>(this.disabledSettings);
            this.update(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEvents(Collection<? extends EventInfo> events) {
        Object object = this.lock;
        synchronized (object) {
            for (EventInfo eventInfo : events) {
                int id = eventInfo.getId();
                this.disabledSettings.remove(id);
                this.eventSettings.remove(id);
            }
            this.globalAggregator.remove(events);
            for (Recording recording : this.recordings) {
                recording.settingsAggregator.remove(events);
            }
        }
    }

    Aggregator subAggregator() {
        return new Aggregator(this.globalAggregator);
    }

    @Override
    public void addEventDefaultSet(EventDefaultSet d) {
        this.globalAggregator.addEventDefaultSet(d);
    }

    @Override
    public Collection<EventDefault> getEventDefaults() {
        return this.globalAggregator.getEventDefaults();
    }

    @Override
    public List<EventDefaultSet> getEventDefaultSets() {
        return this.globalAggregator.getEventDefaultSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventSetting getSetting(int id) throws NoSuchEventException {
        Object object = this.lock;
        synchronized (object) {
            EventSetting s = this.eventSettings.get(id);
            if (s == null) {
                throw new NoSuchEventException(String.valueOf(id));
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<EventSetting> getSettings() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<EventSetting>(this.eventSettings.values());
        }
    }

    @Override
    public void putSettings(Collection<EventSetting> settings) {
        throw new IllegalStateException("No allowed");
    }

    @Override
    public void replaceEventDefaultSets(Collection<EventDefaultSet> l) {
        this.globalAggregator.replaceEventDefaultSets(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Aggregator
    implements EventSettings {
        private final CopyOnWriteArrayList<EventDefaultSet> defaultSets = new CopyOnWriteArrayList();
        private final HashMap<Integer, EventSetting> defaults = new HashMap();
        private final HashMap<Integer, EventSetting> settings = new HashMap();
        private final Aggregator parent;

        Aggregator() {
            this(null);
        }

        Aggregator(Aggregator parent) {
            this.parent = parent;
        }

        private void updateDefaults() {
            this.updateDefaults(Settings.this.eventControls.values());
            Settings.this.update();
        }

        void updateDefaults(Collection<? extends EventInfo> events) {
            assert (Thread.holdsLock(Settings.this.lock));
            this.mergeDefaults(events, this.defaults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Collection<? extends EventInfo> events) {
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventInfo eventInfo : events) {
                    int id = eventInfo.getId();
                    this.defaults.remove(id);
                    this.settings.remove(id);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void putAll(Collection<? extends EventInfo> events, Map<Integer, EventSetting> result) {
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventInfo eventInfo : events) {
                    int id = eventInfo.getId();
                    result.put(id, this.get(id));
                }
            }
        }

        void mergeAll(Map<Integer, EventSetting> result) {
            assert (Thread.holdsLock(Settings.this.lock));
            for (Map.Entry<Integer, EventSetting> e : result.entrySet()) {
                int id = e.getKey();
                EventSetting o = e.getValue();
                EventSetting s = this.get0(id);
                if (s == null || s == o) continue;
                e.setValue(new EventSetting(s, o));
            }
        }

        public Collection<EventSetting> getSettings(Collection<? extends EventInfo> events) {
            HashMap<Integer, EventSetting> result = new HashMap<Integer, EventSetting>();
            this.putAll(events, result);
            return result.values();
        }

        @Override
        public Collection<EventSetting> getSettings() {
            return this.getSettings(Settings.this.eventControls.values());
        }

        private EventSetting get0(int id) {
            EventSetting s = null;
            if (!this.settings.isEmpty()) {
                s = this.settings.get(id);
            }
            if (s == null && !this.defaults.isEmpty()) {
                s = this.defaults.get(id);
            }
            if (s == null && this.parent != null) {
                s = this.parent.get0(id);
            }
            return s;
        }

        private EventSetting get(int id) {
            EventSetting s = this.get0(id);
            if (s == null) {
                s = (EventSetting)Settings.this.disabledSettings.get(id);
            }
            return s;
        }

        private boolean exists(int id) {
            return Settings.this.disabledSettings.containsKey(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EventSetting getSetting(int id) throws NoSuchEventException {
            Object object = Settings.this.lock;
            synchronized (object) {
                EventSetting s = this.get(id);
                if (s == null) {
                    throw new NoSuchEventException(String.valueOf(id));
                }
                return s;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putSettings(Collection<EventSetting> settings) {
            HashMap<Integer, EventSetting> result = new HashMap<Integer, EventSetting>();
            Object object = Settings.this.lock;
            synchronized (object) {
                for (EventSetting s : settings) {
                    int id = s.getId();
                    if (!this.exists(id)) continue;
                    result.put(id, s);
                }
                this.settings.putAll(result);
                Settings.this.update(result);
            }
        }

        public void putSetting(EventSetting s) {
            this.putSettings(Collections.singletonList(s));
        }

        @Override
        public Collection<EventDefault> getEventDefaults() {
            ArrayList<EventDefault> l = new ArrayList<EventDefault>();
            for (EventDefaultSet d : this.defaultSets) {
                l.addAll(d.getAll());
            }
            return l;
        }

        @Override
        public List<EventDefaultSet> getEventDefaultSets() {
            return this.defaultSets;
        }

        @Override
        public void addEventDefaultSet(EventDefaultSet d) {
            this.defaultSets.add(d);
            this.updateDefaults();
        }

        @Override
        public void replaceEventDefaultSets(Collection<EventDefaultSet> l) {
            this.defaultSets.clear();
            this.defaultSets.addAll(l);
            this.updateDefaults();
        }

        private void mergeDefaults(Collection<? extends EventInfo> input, Map<Integer, EventSetting> dest) {
            if (this.defaultSets.isEmpty()) {
                return;
            }
            for (EventInfo eventInfo : input) {
                EventSetting s = this.getDefault(eventInfo);
                if (eventInfo == null) continue;
                dest.put(eventInfo.getId(), s);
            }
        }

        private EventSetting getDefault(EventInfo e) {
            EventSetting s = null;
            for (EventDefaultSet f : this.defaultSets) {
                EventSetting s2 = f.get(e.getURI());
                if (s2 == null) continue;
                s = new EventSetting(e, s2);
            }
            return s;
        }

        public void copy(Aggregator from) {
            assert (this.parent == from.parent);
            this.putSettings(from.settings.values());
            this.replaceEventDefaultSets(from.defaultSets);
            assert (this.equals(from));
        }

        public boolean equals(Aggregator o) {
            if (o == null) {
                return false;
            }
            return this.equals(this.settings, o.settings) && this.equals(this.defaultSets, o.defaultSets) && this.equals(this.defaults, o.defaults) && this.equals(this.parent, o.parent);
        }

        private boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 != null;
            }
            return o1.equals(o2);
        }
    }
}

