/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;

public class Repository {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private final File path;
    private final File lock;
    private final Logger logger;
    private final String pid;

    public Repository(JFR jfr, Options options, Logger logger) {
        File f;
        String basename;
        this.logger = logger;
        this.pid = String.valueOf(jfr.getpid());
        String repo = options.repository();
        if (repo == null) {
            repo = System.getProperty("java.io.tmpdir");
        }
        String name = basename = this.repositoryName();
        int i = 0;
        while (!this.tryToUseAsRepository(f = new File(repo, name))) {
            name = basename + "_" + i++;
        }
        this.path = f;
        this.lock = new File(f, ".lock");
        this.logger.log(MsgLevel.INFO, "Using %s as Flight Recorder repository.", this.path.toString());
    }

    private boolean tryToUseAsRepository(final File path) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    path.getCanonicalFile().getParentFile().mkdirs();
                    if (path.exists()) {
                        return false;
                    }
                    if (!path.mkdir()) {
                        return false;
                    }
                    if (!path.exists()) {
                        return false;
                    }
                    if (new File(path, ".lock").exists()) {
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    Repository.this.logger.log(MsgLevel.WARN, e, "Could not open %s as repository.", path);
                    return false;
                }
            }
        });
    }

    final void lock() throws IOException {
        while (!this.lock.createNewFile()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    final void unlock() {
        assert (this.lock.exists());
        while (!this.lock.delete()) {
            this.logger.error("Could not unlock repository!");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    final String filenameBase() {
        return this.sdf.format(new Date()) + "_" + this.pid;
    }

    public final File getPath() {
        return this.path;
    }

    private final String repositoryName() {
        return this.filenameBase();
    }

    public void destroy() {
        this.logger.info("Deleting Flight Recorder repository");
        if (!this.path.delete()) {
            this.logger.error("Repository could not be removed at shutdown: " + this.path.getAbsoluteFile());
        }
    }
}

