/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.management.ObjectName;
import oracle.jrockit.jfr.ChunksChannel;
import oracle.jrockit.jfr.RecordingObserver;
import oracle.jrockit.jfr.RecordingOptions;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.Settings;
import oracle.jrockit.jfr.settings.EventSettings;
import oracle.jrockit.log.Logger;
import oracle.jrockit.log.MsgLevel;

public final class Recording
implements RecordingOptions {
    private final long id;
    private final Timer timer;
    private final String name;
    private final Logger logger;
    private final boolean isClone;
    private boolean toDisk = true;
    private boolean isStarting;
    private TimerTask startTask;
    private TimerTask stopTask;
    private Date startTime;
    private Date endTime;
    private long duration;
    private long maxSize;
    private long maxAge;
    private long size;
    private volatile boolean done;
    private volatile boolean stoppingDone;
    private boolean started;
    private volatile boolean released;
    private boolean destinationCompressed;
    private String dest;
    private final LinkedList<RepositoryChunk> chunks = new LinkedList();
    private List<RecordingObserver> observers = Collections.emptyList();
    private final Object chunkLock = new Object();
    private final Object observerLock = new Object();
    final Settings.Aggregator settingsAggregator;
    ObjectName objectName;

    Recording(Logger logger, Timer timer, String name, long id, Settings.Aggregator settings, boolean isClone, RecordingObserver ... observers) {
        this.logger = logger;
        this.timer = timer;
        this.name = name;
        this.id = id;
        this.settingsAggregator = settings;
        this.isClone = isClone;
        if (observers.length > 0) {
            this.observers = new ArrayList<RecordingObserver>(Arrays.asList(observers));
        }
    }

    private void added(RepositoryChunk c) {
        c.use();
        this.size += c.getSize();
        if (this.logger.isDebug()) {
            this.logger.log(MsgLevel.DEBUG, "Recording %s:%d added chunk %s, current size=%d", this.name, this.id, c.toString(), this.size);
        }
    }

    private void removed(RepositoryChunk c) {
        this.size -= c.getSize();
        if (this.logger.isDebug()) {
            this.logger.log(MsgLevel.DEBUG, "Recording %s:%d removed chunk %s, current size=%d", this.name, this.id, c.toString(), this.size);
        }
        c.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChunk(RepositoryChunk chunk) {
        if (!this.toDisk) {
            return;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            if (!this.isStarted() || this.done || this.isStarting) {
                return;
            }
            if (this.maxAge != 0L && !this.chunks.isEmpty()) {
                RepositoryChunk c;
                Date oldest = new Date(chunk.getEndTime().getTime() - this.maxAge);
                while (!this.chunks.isEmpty() && !(c = this.chunks.peek()).getEndTime().after(oldest)) {
                    this.chunks.removeFirst();
                    this.removed(c);
                }
            }
            this.chunks.addLast(chunk);
            this.added(chunk);
            while (this.maxSize != 0L && this.size > this.maxSize && this.chunks.size() > 1) {
                RepositoryChunk c = this.chunks.removeFirst();
                this.removed(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(RecordingObserver observer) {
        Object object = this.observerLock;
        synchronized (object) {
            ArrayList<RecordingObserver> newList = new ArrayList<RecordingObserver>();
            newList.addAll(this.observers);
            newList.add(observer);
            this.observers = newList;
        }
    }

    public long getActualDuration(TimeUnit unit) {
        if (!this.isStopped()) {
            return 0L;
        }
        return unit.convert(this.endTime.getTime() - this.startTime.getTime(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDataEndTime() {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            RepositoryChunk chunk = this.chunks.getLast();
            return chunk.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDataStartTime() {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.chunks.isEmpty()) {
                return null;
            }
            RepositoryChunk chunk = this.chunks.getFirst();
            return chunk.getStartTime();
        }
    }

    public long getDataSize() {
        return this.size;
    }

    public long getDuration(TimeUnit unit) {
        return unit.convert(this.duration, TimeUnit.MILLISECONDS);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableByteChannel getChannel() throws IOException {
        Object object = this.chunkLock;
        synchronized (object) {
            return new ChunksChannel(this.chunks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadableByteChannel getChannel(Date startTime, Date endTime) throws IOException {
        Object object = this.chunkLock;
        synchronized (object) {
            ArrayList<RepositoryChunk> l = new ArrayList<RepositoryChunk>(this.chunks.size());
            for (RepositoryChunk c : this.chunks) {
                Date start = c.getStartTime();
                Date end = c.getEndTime();
                if (end.before(startTime)) continue;
                if (start.compareTo(endTime) > 0) break;
                l.add(c);
            }
            return new ChunksChannel(l);
        }
    }

    public InputStream getInputStream() throws IOException {
        return Channels.newInputStream(this.getChannel());
    }

    public InputStream getInputStream(Date startTime, Date endTime) throws IOException {
        return Channels.newInputStream(this.getChannel(startTime, endTime));
    }

    public long getMaxAge(TimeUnit unit) {
        return unit.convert(this.maxAge, TimeUnit.MILLISECONDS);
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean isRunning() {
        return this.isStarted() && this.endTime == null;
    }

    boolean isStoppingDone() {
        return this.stoppingDone;
    }

    public boolean isReleased() {
        return this.released;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isBound() {
        return this.objectName != null;
    }

    public void setToDisk(boolean b) {
        if (this.isStarted()) {
            throw new IllegalStateException("Recording is started");
        }
        this.toDisk = b;
    }

    public boolean isToDisk() {
        return this.toDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.chunkLock;
        synchronized (object) {
            for (RepositoryChunk c : this.chunks) {
                this.removed(c);
            }
            this.chunks.clear();
            this.released = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(RecordingObserver observer) {
        Object object = this.observerLock;
        synchronized (object) {
            ArrayList<RecordingObserver> newList = new ArrayList<RecordingObserver>();
            for (RecordingObserver o : this.observers) {
                if (o == observer) continue;
                newList.add(o);
            }
            this.observers = newList;
        }
    }

    public void setDuration(long time, TimeUnit unit) {
        this.duration = TimeUnit.MILLISECONDS.convert(time, unit);
        this.updateTimer();
    }

    public void setMaxAge(long time, TimeUnit unit) {
        this.maxAge = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public void setMaxSize(long bytes) {
        this.maxSize = bytes;
    }

    public boolean isClone() {
        return this.isClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        List<RecordingObserver> list;
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.endTime != null) {
                throw new IllegalStateException("Recording finished");
            }
            if (this.started) {
                return;
            }
            this.started = true;
            boolean bl = this.isStarting = !this.isClone;
            if (this.startTime == null) {
                this.startTime = new Date();
            }
            this.updateTimer();
            this.logger.info("Starting recording " + this);
        }
        Object object2 = this.observerLock;
        synchronized (object2) {
            list = this.observers;
        }
        for (RecordingObserver o : list) {
            o.started(this);
        }
        object2 = this.chunkLock;
        synchronized (object2) {
            this.isStarting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        List<RecordingObserver> list;
        Object object = this.chunkLock;
        synchronized (object) {
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            if (this.endTime != null) {
                return;
            }
            this.endTime = new Date();
            this.updateTimer();
        }
        Object object2 = this.observerLock;
        synchronized (object2) {
            list = this.observers;
        }
        for (RecordingObserver o : list) {
            o.stopping(this);
        }
        this.stoppingDone = true;
        for (RecordingObserver o : list) {
            o.stopped(this);
        }
        if (this.dest != null) {
            try {
                this.copyTo(this.dest, this.destinationCompressed);
            }
            catch (IOException e) {
                this.dest = null;
                throw e;
            }
        }
        this.done = true;
        this.logger.info("Stopped recording " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(String path, boolean compress) throws IOException {
        File f = new File(path);
        try {
            int n;
            block14: {
                ChunksChannel src;
                Object object = this.chunkLock;
                synchronized (object) {
                    src = new ChunksChannel(this.chunks);
                    n = this.chunks.size();
                }
                this.logger.log(MsgLevel.DEBUG, "Copy %d chunks to %s", n, f.getPath());
                FileChannel out = null;
                try {
                    FileOutputStream os = new FileOutputStream(f);
                    try {
                        if (!compress) {
                            out = os.getChannel();
                            src.transferTo(out);
                            out.force(true);
                            break block14;
                        }
                        GZIPOutputStream gz = new GZIPOutputStream(os);
                        ByteBuffer buf = ByteBuffer.allocate(5120);
                        while (true) {
                            buf.clear();
                            if (src.read(buf) == -1) {
                                gz.flush();
                                gz.finish();
                                gz.close();
                                break;
                            }
                            gz.write(buf.array(), 0, buf.position());
                        }
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    src.close();
                }
            }
            this.logger.log(MsgLevel.INFO, "Copied %d chunks to %s", n, f.getPath());
        }
        catch (IOException e) {
            this.logger.log(MsgLevel.ERROR, e, "Could not copy to %s", f.getPath());
            f.delete();
            throw e;
        }
    }

    public String getDestination() {
        return this.dest;
    }

    public void setDestination(String path) throws IOException {
        if (path != null) {
            File destFile = new File(path);
            FileWriter fw = new FileWriter(destFile);
            fw.close();
        }
        this.dest = path;
    }

    public boolean isDestinationCompressed() {
        return this.destinationCompressed;
    }

    public void setDestinationCompressed(boolean destinationCompressed) {
        this.destinationCompressed = destinationCompressed;
    }

    public void setOptions(RecordingOptions o) throws IOException {
        this.setDestination(o.getDestination());
        this.setDuration(o.getDuration(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.setMaxAge(o.getMaxAge(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.setMaxSize(o.getMaxSize());
        this.setStartTime(o.getStartTime());
        this.setDestinationCompressed(o.isDestinationCompressed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimer() {
        if (!this.isStarted()) {
            return;
        }
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.stopTask != null) {
                this.stopTask.cancel();
                this.stopTask = null;
            }
            if (this.endTime != null) {
                return;
            }
            if (this.duration != 0L) {
                this.stopTask = new TimerTask(){

                    public void run() {
                        try {
                            Recording.this.stop();
                        }
                        catch (Throwable t) {
                            Recording.this.logger.error("Exception when stopping recording:", t);
                        }
                    }
                };
                this.timer.schedule(this.stopTask, new Date(this.startTime.getTime() + this.duration));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartTime(Date startTime) {
        Object object = this.chunkLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            if (this.startTask != null) {
                this.startTask.cancel();
                this.startTask = null;
            }
            if (startTime != null && !this.isClone) {
                this.startTask = new TimerTask(){

                    public void run() {
                        try {
                            Recording.this.start();
                        }
                        catch (IllegalStateException e) {
                            assert (Recording.this.isStarted());
                        }
                        catch (Throwable t) {
                            Recording.this.logger.error("Error when starting recording:", t);
                        }
                    }
                };
                this.timer.schedule(this.startTask, startTime);
            }
            this.startTime = startTime;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[id=").append(this.id);
        if (this.name != null) {
            buf.append(", name=").append(this.name);
        }
        if (this.dest != null) {
            buf.append(", destination=").append(this.dest);
        }
        if (this.startTime != null) {
            buf.append(", start=").append(this.startTime);
        }
        if (this.endTime != null) {
            buf.append(", end=").append(this.endTime);
        }
        if (this.duration != 0L) {
            buf.append(", duration=").append(this.duration).append("ms");
        }
        if (this.maxSize != 0L) {
            buf.append(", maxSize=").append(this.maxSize);
        }
        if (this.maxAge != 0L) {
            buf.append(", maxAge=").append(this.maxAge).append("ms");
        }
        buf.append(']');
        return buf.toString();
    }

    public int hashCode() {
        return (int)this.id;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChunks(Recording other) {
        ArrayList<RepositoryChunk> l = new ArrayList<RepositoryChunk>();
        Object object = other.chunkLock;
        synchronized (object) {
            l.addAll(other.chunks);
        }
        object = this.chunkLock;
        synchronized (object) {
            l.addAll(this.chunks);
            Collections.sort(l, new Comparator<RepositoryChunk>(){

                @Override
                public int compare(RepositoryChunk o1, RepositoryChunk o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
            for (int i = 0; i < l.size(); ++i) {
                RepositoryChunk c = (RepositoryChunk)l.get(i);
                if (i != l.size() - 1 && c == l.get(i + 1) || i != 0 && c == l.get(i - 1)) continue;
                this.chunks.add(c);
                this.added(c);
            }
        }
    }

    public EventSettings getEventSettings() {
        return this.settingsAggregator;
    }
}

