/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.jrockit.jfr.NativeEventControl;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeProducerDescriptor
implements ProducerDescriptor {
    private final int id;
    private final List<NativeEventControl> controls;
    private final String name;
    private final String desc;
    private final URI uri;

    NativeProducerDescriptor(int pid, VMJFR vmjfr) throws URISyntaxException, UnsupportedEncodingException {
        this.id = pid;
        ByteBuffer[] buffers = new ByteBuffer[2];
        int eventoffset = vmjfr.descriptors(pid, buffers);
        ByteBuffer eventcontrol = buffers[0].order(ByteOrder.nativeOrder());
        ByteBuffer descriptor = buffers[1];
        ByteBuffer eventsection = descriptor.duplicate();
        eventsection.position(eventoffset);
        descriptor.getInt();
        this.name = this.readUTF(descriptor);
        this.desc = this.readUTF(descriptor);
        this.uri = new URI(this.readUTF(descriptor));
        int offset = 0;
        int n = eventsection.getInt();
        ArrayList<NativeEventControl> l = new ArrayList<NativeEventControl>();
        HashMap<String, NativeEventControl> paths = new HashMap<String, NativeEventControl>();
        for (int i = 0; i < n; ++i) {
            int id = eventsection.getInt();
            String name = this.readUTF(eventsection);
            String desc = this.readUTF(eventsection);
            String path = this.readUTF(eventsection);
            if (paths.containsKey(path)) {
                throw new InternalError("Event " + name + " uses same path as " + paths.get(path));
            }
            boolean hasStartTime = eventsection.get() != 0;
            boolean hasThread = eventsection.get() != 0;
            boolean canHaveStackTrace = eventsection.get() != 0;
            boolean isRequestable = eventsection.get() != 0;
            eventsection.getInt();
            eventsection.getInt();
            NativeEventControl nc = new NativeEventControl(vmjfr, eventcontrol, offset, id, name, desc, path, this.uri.resolve(path), hasStartTime, hasThread, canHaveStackTrace, isRequestable);
            if (hasStartTime && isRequestable) {
                throw new IllegalStateException("Bad event descriptor : " + nc);
            }
            l.add(nc);
            paths.put(path, nc);
            offset += 16;
        }
        this.controls = Collections.unmodifiableList(l);
    }

    private String readUTF(ByteBuffer b) throws UnsupportedEncodingException {
        short len = b.getShort();
        byte[] buf = new byte[len];
        b.get(buf);
        return new String(buf, 0, (int)len, "UTF-8");
    }

    @Override
    public ByteBuffer getBinaryDescriptor() {
        throw new InternalError("shoudl not reach");
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    List<? extends EventControl> controls() {
        return this.controls;
    }

    @Override
    public Collection<? extends EventDescriptor> getEvents() {
        return this.controls;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public long writeCheckPoint(FileChannel channel, long previous) {
        return 0L;
    }
}

