/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import java.net.URI;
import java.nio.ByteBuffer;
import oracle.jrockit.jfr.VMJFR;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

class NativeEventControl
implements EventControl,
EventDescriptor {
    private long period;
    private long nanoThreshold;
    private final VMJFR vmjfr;
    private final ByteBuffer control;
    private final int offset;
    private final int id;
    private final String name;
    private final String desc;
    private final String path;
    private final URI uri;
    private final boolean hasStartTime;
    private final boolean hasThread;
    private final boolean canHaveStackTrace;
    private final boolean isRequestable;

    NativeEventControl(VMJFR vmjfr, ByteBuffer control, int offset, int id, String name, String desc, String path, URI uri, boolean hasStartTime, boolean hasThread, boolean canHaveStackTrace, boolean isRequestable) {
        this.vmjfr = vmjfr;
        this.control = control;
        this.offset = offset;
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.path = path;
        this.uri = uri;
        this.hasStartTime = hasStartTime;
        this.hasThread = hasThread;
        this.canHaveStackTrace = canHaveStackTrace;
        this.isRequestable = isRequestable;
        this.period = this.isRequestable() ? vmjfr.getPeriod(id) : 0L;
    }

    public void apply(EventSetting s) {
        this.setEnabled(s.isEnabled());
        this.setStackTraceEnabled(s.isStacktraceEnabled());
        this.setThreshold(s.getThreshold());
        this.setPeriod(s.getPeriod());
    }

    public EventDescriptor getDescriptor() {
        return this;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setEnabled(boolean enabled) {
        if (this.isRequestable()) {
            if (enabled) {
                this.vmjfr.setPeriod(this.id, this.period);
            } else {
                this.vmjfr.setPeriod(this.id, 0L);
            }
        }
        if (this.isEnabled() != enabled) {
            this.vmjfr.setEnabled(this.id, enabled);
        }
    }

    public void setPeriod(long period) {
        if (this.isRequestable()) {
            if (this.isEnabled()) {
                this.vmjfr.setPeriod(this.id, period);
            }
            this.period = period;
        }
    }

    public void setStackTraceEnabled(boolean stacktraceOn) {
        if (this.hasStackTrace()) {
            this.control.put(this.offset + 8, stacktraceOn ? (byte)1 : 0);
        }
    }

    public void setThreshold(long nanoThreshold) {
        if (this.isTimed()) {
            this.vmjfr.setThreshold(this.id, nanoThreshold);
            this.nanoThreshold = nanoThreshold;
        }
    }

    public String getDescription() {
        return this.desc;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getThresholdTicks() {
        return this.control.getLong(this.offset);
    }

    public long getThreshold() {
        return this.nanoThreshold;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean hasStackTrace() {
        return this.canHaveStackTrace;
    }

    public boolean hasThread() {
        return this.hasThread;
    }

    public boolean isEnabled() {
        return this.control.get(this.offset + 9) != 0;
    }

    public boolean isRequestable() {
        return this.isRequestable;
    }

    public boolean isStackTraceEnabled() {
        return this.control.get(this.offset + 8) != 0;
    }

    public boolean isTimed() {
        return this.hasStartTime;
    }

    public boolean hasStartTime() {
        return this.hasStartTime;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.isTimed()) {
            buf.append("{ Timed event id=");
        } else if (this.isRequestable()) {
            buf.append("{ Requestable event id=");
        } else {
            buf.append("{ Event id=");
        }
        buf.append(this.id).append(", name=").append(this.name);
        buf.append(", uri=").append(this.uri);
        if (this.isEnabled()) {
            buf.append(", enabled");
        }
        if (this.hasThread) {
            buf.append(", thread");
        }
        if (this.hasStackTrace()) {
            buf.append(", stacktrace(").append(this.isStackTraceEnabled() ? "on" : "off").append(')');
        }
        if (this.isTimed()) {
            buf.append(", threshold=").append(this.getThreshold()).append("ns");
        }
        if (this.isRequestable()) {
            buf.append(", period=").append(this.getPeriod()).append("ms");
        }
        buf.append(" }");
        return buf.toString();
    }
}

