/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.DataType;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.events.Bits;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.settings.EventSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetaProducer
implements ProducerDescriptor {
    private static final int EVENTSETTING_SIZE = DataType.INTEGER.getSize() + 2 * DataType.LONG.getSize() + 2 * DataType.BOOLEAN.getSize();
    private static final int OVERHEAD_SIZE = 16;
    private final URI uri;
    private final int id;
    private final ArrayList<Control> controls = new ArrayList();
    private final Control recordingsEvent;
    private final Control settingsEvent;
    private final ByteBuffer descriptor;
    private final JFRImpl jfr;
    private boolean hasChunk;

    public MetaProducer(JFRImpl jfr) {
        this.jfr = jfr;
        this.id = jfr.nextID();
        try {
            this.uri = new URI("http://www.oracle.com/jrockit/jfr-info/");
        }
        catch (URISyntaxException e) {
            throw new InternalError();
        }
        this.recordingsEvent = new Control(jfr.nextID(), "recordings/active", "List of Active Recordings", "");
        this.settingsEvent = new Control(jfr.nextID(), "recordings/settingsChanged", "Event Settings Changed", "");
        this.controls.add(this.recordingsEvent);
        this.controls.add(this.settingsEvent);
        this.descriptor = this.createBinaryDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewChunk() {
        this.hasChunk = true;
        if (this.recordingsEvent.isEnabled()) {
            int n = 0;
            int size = 24;
            Collection<Recording> recordings = this.jfr.getRecordings();
            Collection<EventSetting> settings = this.jfr.getEventSettings().getSettings();
            Iterator<Recording> i = recordings.iterator();
            while (i.hasNext()) {
                Recording r = i.next();
                if (!r.isStarted() || r.isStoppingDone()) {
                    i.remove();
                    continue;
                }
                size += DataType.LONG.getSize() + DataType.INTEGER.getSize() + Bits.length(r.getName());
            }
            for (EventSetting s : settings) {
                if (!s.isEnabled()) continue;
                size += EVENTSETTING_SIZE;
                ++n;
            }
            boolean ok = false;
            ByteBuffer buf = this.jfr.getThreadBuffer(size);
            try {
                buf.putInt(size);
                buf.putInt(this.recordingsEvent.getId());
                buf.putLong(this.jfr.counterTime());
                buf.putInt(recordings.size());
                for (Recording r : recordings) {
                    buf.putLong(r.getId());
                    Bits.write(buf, r.getName());
                }
                buf.putInt(n);
                for (EventSetting s : settings) {
                    if (!s.isEnabled()) continue;
                    buf.putInt(s.getId());
                    buf.put(s.isEnabled() ? (byte)1 : 0);
                    buf.put(s.isStacktraceEnabled() ? (byte)1 : 0);
                    buf.putLong(s.getThreshold());
                    buf.putLong(s.getPeriod());
                }
                ok = true;
            }
            finally {
                this.jfr.releaseThreadBuffer(buf, ok);
            }
        }
    }

    public void chunkDone() {
        this.hasChunk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(Collection<EventSetting> settings, Map<Integer, EventSetting> old) {
        if (!this.settingsEvent.isEnabled() || !this.hasChunk) {
            return;
        }
        ArrayList<EventSetting> changed = new ArrayList<EventSetting>(settings.size());
        for (EventSetting s : settings) {
            EventSetting o = old.get(s.getId());
            if (o != null && o.equals(s)) continue;
            changed.add(s);
        }
        if (!changed.isEmpty()) {
            int size = 20;
            boolean ok = false;
            ByteBuffer buf = this.jfr.getThreadBuffer(size += changed.size() * EVENTSETTING_SIZE);
            try {
                buf.putInt(size);
                buf.putInt(this.settingsEvent.getId());
                buf.putLong(this.jfr.counterTime());
                buf.putInt(changed.size());
                for (EventSetting s : changed) {
                    buf.putInt(s.getId());
                    buf.put(s.isEnabled() ? (byte)1 : 0);
                    buf.put(s.isStacktraceEnabled() ? (byte)1 : 0);
                    buf.putLong(s.getThreshold());
                    buf.putLong(s.getPeriod());
                }
                ok = true;
            }
            finally {
                this.jfr.releaseThreadBuffer(buf, ok);
            }
        }
    }

    private void writeField(DataOutputStream out, String field, String name, DataType type, int arrayType) throws IOException {
        out.writeUTF(field);
        out.writeUTF(name);
        out.writeUTF("");
        out.write(0);
        out.write(type.ordinal());
        out.writeInt(0);
        out.writeInt(arrayType);
        out.writeInt(0);
    }

    private void writeField(DataOutputStream out, String field, String name, DataType type) throws IOException {
        this.writeField(out, field, name, type, 0);
    }

    private void writeEvent(DataOutputStream out, Control c, int index) throws IOException {
        out.writeInt(c.getId());
        out.writeUTF(c.getName());
        out.writeUTF(c.getDescription());
        out.writeUTF(c.getPath());
        out.writeBoolean(c.hasStartTime());
        out.writeBoolean(c.hasThread());
        out.writeBoolean(c.hasStackTrace());
        out.writeBoolean(c.isRequestable());
        out.writeInt(index);
        out.writeInt(0);
    }

    private ByteBuffer createBinaryDescriptor() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        try {
            out.writeInt(this.getId());
            out.writeUTF(this.getName());
            out.writeUTF(this.getDescription());
            out.writeUTF(this.getURI().toString());
            out.writeInt(0);
            out.writeInt(4);
            out.writeInt(2);
            this.writeField(out, "id", "Id", DataType.LONG);
            this.writeField(out, "name", "Name", DataType.STRING);
            out.writeInt(5);
            this.writeField(out, "id", "Id", DataType.INTEGER);
            this.writeField(out, "enabled", "Enabled", DataType.BOOLEAN);
            this.writeField(out, "stacktrace", "Stacktrace", DataType.BOOLEAN);
            this.writeField(out, "threshold", "Threshold", DataType.LONG);
            this.writeField(out, "period", "Period", DataType.LONG);
            out.writeInt(2);
            this.writeField(out, "recordings", "Recordings", DataType.STRUCTARRAY, 0);
            this.writeField(out, "settings", "Active Settings", DataType.STRUCTARRAY, 1);
            out.writeInt(1);
            this.writeField(out, "settings", "Changed Settings", DataType.STRUCTARRAY, 1);
            out.writeInt(2);
            this.writeEvent(out, this.recordingsEvent, 2);
            this.writeEvent(out, this.settingsEvent, 3);
            out.writeInt(0);
            out.flush();
            out.close();
            return ByteBuffer.wrap(bout.toByteArray());
        }
        catch (IOException e) {
            throw (InternalError)new InternalError("Could not create descriptors").initCause(e);
        }
    }

    @Override
    public ByteBuffer getBinaryDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getDescription() {
        return "Information about Recordings and Settings";
    }

    public Collection<? extends EventControl> getControls() {
        return this.controls;
    }

    @Override
    public Collection<? extends EventDescriptor> getEvents() {
        return this.controls;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return "JFR Metadata";
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public long writeCheckPoint(FileChannel channel, long previous) throws IOException {
        return previous;
    }

    class Control
    implements EventControl,
    EventDescriptor {
        private boolean enabled;
        private final int id;
        private final String path;
        private final String name;
        private final String description;
        private final URI uri;

        public Control(int id, String path, String name, String description) {
            this.id = id;
            this.path = path;
            this.name = name;
            this.description = description;
            this.uri = MetaProducer.this.uri.resolve(path);
        }

        public void apply(EventSetting s) {
            this.setEnabled(s.isEnabled());
        }

        public EventDescriptor getDescriptor() {
            return this;
        }

        public long getPeriod() {
            return 0L;
        }

        public long getThresholdTicks() {
            return 0L;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPeriod(long period) {
        }

        public void setStackTraceEnabled(boolean stacktraceOn) {
        }

        public void setThreshold(long nanoThreshold) {
        }

        public String getDescription() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public long getThreshold() {
            return 0L;
        }

        public URI getURI() {
            return this.uri;
        }

        public boolean hasStackTrace() {
            return false;
        }

        public boolean hasStartTime() {
            return false;
        }

        public boolean hasThread() {
            return false;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRequestable() {
            return false;
        }

        public boolean isStackTraceEnabled() {
            return false;
        }

        public boolean isTimed() {
            return false;
        }
    }
}

